extends Shape3D
class_name WorldBoundaryShape3D

## A 3D world boundary (half-space) shape used for physics collision.
##
## A 3D world boundary shape, intended for use in physics. [WorldBoundaryShape3D] works like an infinite plane that forces all physics bodies to stay above it. The [member plane]'s normal determines which direction is considered as "above" and in the editor, the line over the plane represents this direction. It can for example be used for endless flat floors.
## [b]Note:[/b] When the physics engine is set to [b]Jolt Physics[/b] in the project settings ([member ProjectSettings.physics/3d/physics_engine]), [WorldBoundaryShape3D] has a finite size (centered at the shape's origin). It can be adjusted by changing [member ProjectSettings.physics/jolt_physics_3d/limits/world_boundary_shape_size].



## The [Plane] used by the [WorldBoundaryShape3D] for collision.
var plane: Plane:
	get = get_plane, set = set_plane




func get_plane() -> Plane:
	return plane

func set_plane(value: Plane) -> void:
	plane = value

