extends VisualShaderNodeSample3D
class_name VisualShaderNodeTexture2DArray

## A 2D texture uniform array to be used within the visual shader graph.
##
## Translated to [code]uniform sampler2DArray[/code] in the shader language.



## A source texture array. Used if [member VisualShaderNodeSample3D.source] is set to [constant VisualShaderNodeSample3D.SOURCE_TEXTURE].
var texture_array: TextureLayered:
	get = get_texture_array, set = set_texture_array




func get_texture_array() -> TextureLayered:
	return texture_array

func set_texture_array(value: TextureLayered) -> void:
	texture_array = value

