extends VisualShaderNode
class_name VisualShaderNodeCompare

## A comparison function for common types within the visual shader graph.
##
## Compares [code]a[/code] and [code]b[/code] of [member type] by [member function]. Returns a boolean scalar. Translates to [code]if[/code] instruction in shader code.


## A floating-point scalar.
## An integer scalar.
## An unsigned integer scalar.
## A 2D vector type.
## A 3D vector type.
## A 4D vector type.
## A boolean type.
## A transform ([code]mat4[/code]) type.
## Represents the size of the [enum ComparisonType] enum.
## Comparison for equality ([code]a == b[/code]).
## Comparison for inequality ([code]a != b[/code]).
## Comparison for greater than ([code]a > b[/code]). Cannot be used if [member type] set to [constant CTYPE_BOOLEAN] or [constant CTYPE_TRANSFORM].
## Comparison for greater than or equal ([code]a >= b[/code]). Cannot be used if [member type] set to [constant CTYPE_BOOLEAN] or [constant CTYPE_TRANSFORM].
## Comparison for less than ([code]a < b[/code]). Cannot be used if [member type] set to [constant CTYPE_BOOLEAN] or [constant CTYPE_TRANSFORM].
## Comparison for less than or equal ([code]a <= b[/code]). Cannot be used if [member type] set to [constant CTYPE_BOOLEAN] or [constant CTYPE_TRANSFORM].
## Represents the size of the [enum Function] enum.
## The result will be [code]true[/code] if all components in the vector satisfy the comparison condition.
## The result will be [code]true[/code] if any component in the vector satisfies the comparison condition.
## Represents the size of the [enum Condition] enum.

#enum ComparisonType
enum {
    CTYPE_SCALAR = 0,
    CTYPE_SCALAR_INT = 1,
    CTYPE_SCALAR_UINT = 2,
    CTYPE_VECTOR_2D = 3,
    CTYPE_VECTOR_3D = 4,
    CTYPE_VECTOR_4D = 5,
    CTYPE_BOOLEAN = 6,
    CTYPE_TRANSFORM = 7,
    CTYPE_MAX = 8,
}
#enum Function
enum {
    FUNC_EQUAL = 0,
    FUNC_NOT_EQUAL = 1,
    FUNC_GREATER_THAN = 2,
    FUNC_GREATER_THAN_EQUAL = 3,
    FUNC_LESS_THAN = 4,
    FUNC_LESS_THAN_EQUAL = 5,
    FUNC_MAX = 6,
}
#enum Condition
enum {
    COND_ALL = 0,
    COND_ANY = 1,
    COND_MAX = 2,
}
## Extra condition which is applied if [member type] is set to [constant CTYPE_VECTOR_3D].
var condition: int:
	get = get_condition, set = set_condition

## A comparison function. See [enum Function] for options.
var function: int:
	get = get_function, set = set_function

## The type to be used in the comparison. See [enum ComparisonType] for options.
var type: int:
	get = get_comparison_type, set = set_comparison_type




func get_condition() -> int:
	return condition

func set_condition(value: int) -> void:
	condition = value

func get_function() -> int:
	return function

func set_function(value: int) -> void:
	function = value

func get_comparison_type() -> int:
	return type

func set_comparison_type(value: int) -> void:
	type = value

