extends VisualShaderNode
class_name VisualShaderNodeColorFunc

## A [Color] function to be used within the visual shader graph.
##
## Accept a [Color] to the input port and transform it according to [member function].


## Converts the color to grayscale using the following formula:
## [codeblock]
## vec3 c = input;
## float max1 = max(c.r, c.g);
## float max2 = max(max1, c.b);
## float max3 = max(max1, max2);
## return vec3(max3, max3, max3);
## [/codeblock]
## Converts HSV vector to RGB equivalent.
## Converts RGB vector to HSV equivalent.
## Applies sepia tone effect using the following formula:
## [codeblock]
## vec3 c = input;
## float r = (c.r * 0.393) + (c.g * 0.769) + (c.b * 0.189);
## float g = (c.r * 0.349) + (c.g * 0.686) + (c.b * 0.168);
## float b = (c.r * 0.272) + (c.g * 0.534) + (c.b * 0.131);
## return vec3(r, g, b);
## [/codeblock]
## Converts color from linear color space to sRGB color space using the following formula:
## [codeblock]
## vec3 c = clamp(c, vec3(0.0), vec3(1.0));
## const vec3 a = vec3(0.055f);
## return mix((vec3(1.0f) + a) * pow(c.rgb, vec3(1.0f / 2.4f)) - a, 12.92f * c.rgb, lessThan(c.rgb, vec3(0.0031308f)));
## [/codeblock]
## The Compatibility renderer uses a simpler formula:
## [codeblock]
## vec3 c = input;
## return max(vec3(1.055) * pow(c, vec3(0.416666667)) - vec3(0.055), vec3(0.0));
## [/codeblock]
## Converts color from sRGB color space to linear color space using the following formula:
## [codeblock]
## vec3 c = input;
## return mix(pow((c.rgb + vec3(0.055)) * (1.0 / (1.0 + 0.055)), vec3(2.4)), c.rgb * (1.0 / 12.92), lessThan(c.rgb, vec3(0.04045)));
## [/codeblock]
## The Compatibility renderer uses a simpler formula:
## [codeblock]
## vec3 c = input;
## return c * (c * (c * 0.305306011 + 0.682171111) + 0.012522878);
## [/codeblock]
## Represents the size of the [enum Function] enum.

#enum Function
enum {
    FUNC_GRAYSCALE = 0,
    FUNC_HSV2RGB = 1,
    FUNC_RGB2HSV = 2,
    FUNC_SEPIA = 3,
    FUNC_LINEAR_TO_SRGB = 4,
    FUNC_SRGB_TO_LINEAR = 5,
    FUNC_MAX = 6,
}
## A function to be applied to the input color. See [enum Function] for options.
var function: int:
	get = get_function, set = set_function




func get_function() -> int:
	return function

func set_function(value: int) -> void:
	function = value

