extends VisibleOnScreenNotifier2D
class_name VisibleOnScreenEnabler2D

## A rectangular region of 2D space that, when visible on screen, enables a target node.
##
## [VisibleOnScreenEnabler2D] contains a rectangular region of 2D space and a target node. The target node will be automatically enabled (via its [member Node.process_mode] property) when any part of this region becomes visible on the screen, and automatically disabled otherwise. This can for example be used to activate enemies only when the player approaches them.
## See [VisibleOnScreenNotifier2D] if you only want to be notified when the region is visible on screen.
## [b]Note:[/b] [VisibleOnScreenEnabler2D] uses the render culling code to determine whether it's visible on screen, so it won't function unless [member CanvasItem.visible] is set to [code]true[/code].


## Corresponds to [constant Node.PROCESS_MODE_INHERIT].
## Corresponds to [constant Node.PROCESS_MODE_ALWAYS].
## Corresponds to [constant Node.PROCESS_MODE_WHEN_PAUSED].

#enum EnableMode
enum {
    ENABLE_MODE_INHERIT = 0,
    ENABLE_MODE_ALWAYS = 1,
    ENABLE_MODE_WHEN_PAUSED = 2,
}
## Determines how the target node is enabled. Corresponds to [enum Node.ProcessMode]. When the node is disabled, it always uses [constant Node.PROCESS_MODE_DISABLED].
var enable_mode: int:
	get = get_enable_mode, set = set_enable_mode

## The path to the target node, relative to the [VisibleOnScreenEnabler2D]. The target node is cached; it's only assigned when setting this property (if the [VisibleOnScreenEnabler2D] is inside the scene tree) and every time the [VisibleOnScreenEnabler2D] enters the scene tree. If the path is empty, no node will be affected. If the path is invalid, an error is also generated.
var enable_node_path: NodePath:
	get = get_enable_node_path, set = set_enable_node_path




func get_enable_mode() -> int:
	return enable_mode

func set_enable_mode(value: int) -> void:
	enable_mode = value

func get_enable_node_path() -> NodePath:
	return enable_node_path

func set_enable_node_path(value: NodePath) -> void:
	enable_node_path = value

