extends Resource
class_name VideoStream

## Base resource for video streams.
##
## Base resource type for all video streams. Classes that derive from [VideoStream] can all be used as resource types to play back videos in [VideoStreamPlayer].
##
## @tutorial(Playing videos): https://docs.godotengine.org/en/stable/tutorials/animation/playing_videos.html
## @tutorial(Runtime file loading and saving): https://docs.godotengine.org/en/stable/tutorials/io/runtime_file_loading_and_saving.html



## The video file path or URI that this [VideoStream] resource handles.
## For [VideoStreamTheora], this filename should be an Ogg Theora video file with the [code].ogv[/code] extension.
var file: String:
	get = get_file, set = set_file



## Called when the video starts playing, to initialize and return a subclass of [VideoStreamPlayback].
func _instantiate_playback() -> VideoStreamPlayback:
	pass;


func get_file() -> String:
	return file

func set_file(value: String) -> void:
	file = value

