extends RefCounted
class_name TranslationDomain

## A self-contained collection of [Translation] resources.
##
## [TranslationDomain] is a self-contained collection of [Translation] resources. Translations can be added to or removed from it.
## If you're working with the main translation domain, it is more convenient to use the wrap methods on [TranslationServer].



## Replace all characters with their accented variants during pseudolocalization.
## [b]Note:[/b] Updating this property does not automatically update texts in the scene tree. Please propagate the [constant MainLoop.NOTIFICATION_TRANSLATION_CHANGED] notification manually after you have finished modifying pseudolocalization related options.
var pseudolocalization_accents_enabled: bool:
	get = is_pseudolocalization_accents_enabled, set = set_pseudolocalization_accents_enabled

## Double vowels in strings during pseudolocalization to simulate the lengthening of text due to localization.
## [b]Note:[/b] Updating this property does not automatically update texts in the scene tree. Please propagate the [constant MainLoop.NOTIFICATION_TRANSLATION_CHANGED] notification manually after you have finished modifying pseudolocalization related options.
var pseudolocalization_double_vowels_enabled: bool:
	get = is_pseudolocalization_double_vowels_enabled, set = set_pseudolocalization_double_vowels_enabled

## If [code]true[/code], enables pseudolocalization for the project. This can be used to spot untranslatable strings or layout issues that may occur once the project is localized to languages that have longer strings than the source language.
## [b]Note:[/b] Updating this property does not automatically update texts in the scene tree. Please propagate the [constant MainLoop.NOTIFICATION_TRANSLATION_CHANGED] notification manually after you have finished modifying pseudolocalization related options.
var pseudolocalization_enabled: bool:
	get = is_pseudolocalization_enabled, set = set_pseudolocalization_enabled

## The expansion ratio to use during pseudolocalization. A value of [code]0.3[/code] is sufficient for most practical purposes, and will increase the length of each string by 30%.
## [b]Note:[/b] Updating this property does not automatically update texts in the scene tree. Please propagate the [constant MainLoop.NOTIFICATION_TRANSLATION_CHANGED] notification manually after you have finished modifying pseudolocalization related options.
var pseudolocalization_expansion_ratio: float:
	get = get_pseudolocalization_expansion_ratio, set = set_pseudolocalization_expansion_ratio

## If [code]true[/code], emulate bidirectional (right-to-left) text when pseudolocalization is enabled. This can be used to spot issues with RTL layout and UI mirroring that will crop up if the project is localized to RTL languages such as Arabic or Hebrew.
## [b]Note:[/b] Updating this property does not automatically update texts in the scene tree. Please propagate the [constant MainLoop.NOTIFICATION_TRANSLATION_CHANGED] notification manually after you have finished modifying pseudolocalization related options.
var pseudolocalization_fake_bidi_enabled: bool:
	get = is_pseudolocalization_fake_bidi_enabled, set = set_pseudolocalization_fake_bidi_enabled

## Replace all characters in the string with [code]*[/code]. Useful for finding non-localizable strings.
## [b]Note:[/b] Updating this property does not automatically update texts in the scene tree. Please propagate the [constant MainLoop.NOTIFICATION_TRANSLATION_CHANGED] notification manually after you have finished modifying pseudolocalization related options.
var pseudolocalization_override_enabled: bool:
	get = is_pseudolocalization_override_enabled, set = set_pseudolocalization_override_enabled

## Prefix that will be prepended to the pseudolocalized string.
## [b]Note:[/b] Updating this property does not automatically update texts in the scene tree. Please propagate the [constant MainLoop.NOTIFICATION_TRANSLATION_CHANGED] notification manually after you have finished modifying pseudolocalization related options.
var pseudolocalization_prefix: String:
	get = get_pseudolocalization_prefix, set = set_pseudolocalization_prefix

## Skip placeholders for string formatting like [code]%s[/code] or [code]%f[/code] during pseudolocalization. Useful to identify strings which need additional control characters to display correctly.
## [b]Note:[/b] Updating this property does not automatically update texts in the scene tree. Please propagate the [constant MainLoop.NOTIFICATION_TRANSLATION_CHANGED] notification manually after you have finished modifying pseudolocalization related options.
var pseudolocalization_skip_placeholders_enabled: bool:
	get = is_pseudolocalization_skip_placeholders_enabled, set = set_pseudolocalization_skip_placeholders_enabled

## Suffix that will be appended to the pseudolocalized string.
## [b]Note:[/b] Updating this property does not automatically update texts in the scene tree. Please propagate the [constant MainLoop.NOTIFICATION_TRANSLATION_CHANGED] notification manually after you have finished modifying pseudolocalization related options.
var pseudolocalization_suffix: String:
	get = get_pseudolocalization_suffix, set = set_pseudolocalization_suffix



## Adds a translation.
func add_translation(translation: Translation) -> void:
	pass;

## Removes all translations.
func clear() -> void:
	pass;

## Returns the [Translation] instance that best matches [param locale]. Returns [code]null[/code] if there are no matches.
func get_translation_object(locale: String) -> Translation:
	pass;

## Returns the pseudolocalized string based on the [param message] passed in.
func pseudolocalize(message: StringName) -> StringName:
	pass;

## Removes the given translation.
func remove_translation(translation: Translation) -> void:
	pass;

## Returns the current locale's translation for the given message and context.
func translate(message: StringName, context: StringName = &"") -> StringName:
	pass;

## Returns the current locale's translation for the given message, plural message and context.
## The number [param n] is the number or quantity of the plural object. It will be used to guide the translation system to fetch the correct plural form for the selected language.
func translate_plural(message: StringName, message_plural: StringName, n: int, context: StringName = &"") -> StringName:
	pass;


func is_pseudolocalization_accents_enabled() -> bool:
	return pseudolocalization_accents_enabled

func set_pseudolocalization_accents_enabled(value: bool) -> void:
	pseudolocalization_accents_enabled = value

func is_pseudolocalization_double_vowels_enabled() -> bool:
	return pseudolocalization_double_vowels_enabled

func set_pseudolocalization_double_vowels_enabled(value: bool) -> void:
	pseudolocalization_double_vowels_enabled = value

func is_pseudolocalization_enabled() -> bool:
	return pseudolocalization_enabled

func set_pseudolocalization_enabled(value: bool) -> void:
	pseudolocalization_enabled = value

func get_pseudolocalization_expansion_ratio() -> float:
	return pseudolocalization_expansion_ratio

func set_pseudolocalization_expansion_ratio(value: float) -> void:
	pseudolocalization_expansion_ratio = value

func is_pseudolocalization_fake_bidi_enabled() -> bool:
	return pseudolocalization_fake_bidi_enabled

func set_pseudolocalization_fake_bidi_enabled(value: bool) -> void:
	pseudolocalization_fake_bidi_enabled = value

func is_pseudolocalization_override_enabled() -> bool:
	return pseudolocalization_override_enabled

func set_pseudolocalization_override_enabled(value: bool) -> void:
	pseudolocalization_override_enabled = value

func get_pseudolocalization_prefix() -> String:
	return pseudolocalization_prefix

func set_pseudolocalization_prefix(value: String) -> void:
	pseudolocalization_prefix = value

func is_pseudolocalization_skip_placeholders_enabled() -> bool:
	return pseudolocalization_skip_placeholders_enabled

func set_pseudolocalization_skip_placeholders_enabled(value: bool) -> void:
	pseudolocalization_skip_placeholders_enabled = value

func get_pseudolocalization_suffix() -> String:
	return pseudolocalization_suffix

func set_pseudolocalization_suffix(value: String) -> void:
	pseudolocalization_suffix = value

