extends Texture2D
class_name Texture2DRD

## Texture for 2D that is bound to a texture created on the [RenderingDevice].
##
## This texture class allows you to use a 2D texture created directly on the [RenderingDevice] as a texture for materials, meshes, etc.



var resource_local_to_scene: bool:
	get = is_local_to_scene, set = set_local_to_scene

## The RID of the texture object created on the [RenderingDevice].
var texture_rd_rid: RID:
	get = get_texture_rd_rid, set = set_texture_rd_rid




func is_local_to_scene() -> bool:
	return resource_local_to_scene

func set_local_to_scene(value: bool) -> void:
	resource_local_to_scene = value

func get_texture_rd_rid() -> RID:
	return texture_rd_rid

func set_texture_rd_rid(value: RID) -> void:
	texture_rd_rid = value

