extends TextServer
class_name TextServerExtension

## Base class for custom [TextServer] implementations (plugins).
##
## External [TextServer] implementations should inherit from this class.





## [b]Optional.[/b]
## This method is called before text server is unregistered.
func _cleanup() -> void:
	pass;

## [b]Required.[/b]
## Creates a new, empty font cache entry resource.
func _create_font() -> RID:
	pass;

## Optional, implement if font supports extra spacing or baseline offset.
## Creates a new variation existing font which is reusing the same glyph cache and font data.
func _create_font_linked_variation(font_rid: RID) -> RID:
	pass;

## [b]Required.[/b]
## Creates a new buffer for complex text layout, with the given [param direction] and [param orientation].
func _create_shaped_text(direction: int, orientation: int) -> RID:
	pass;

## [b]Optional.[/b]
## Draws box displaying character hexadecimal code.
func _draw_hex_code_box(canvas: RID, size: int, pos: Vector2, index: int, color: Color) -> void:
	pass;

## [b]Required.[/b]
## Removes all rendered glyph information from the cache entry.
func _font_clear_glyphs(font_rid: RID, size: Vector2i) -> void:
	pass;

## [b]Optional.[/b]
## Removes all kerning overrides.
func _font_clear_kerning_map(font_rid: RID, size: int) -> void:
	pass;

## [b]Required.[/b]
## Removes all font sizes from the cache entry.
func _font_clear_size_cache(font_rid: RID) -> void:
	pass;

## [b]Required.[/b]
## Removes all textures from font cache entry.
func _font_clear_textures(font_rid: RID, size: Vector2i) -> void:
	pass;

## [b]Required.[/b]
## Draws single glyph into a canvas item at the position, using [param font_rid] at the size [param size].
func _font_draw_glyph(font_rid: RID, canvas: RID, size: int, pos: Vector2, index: int, color: Color) -> void:
	pass;

## [b]Required.[/b]
## Draws single glyph outline of size [param outline_size] into a canvas item at the position, using [param font_rid] at the size [param size].
func _font_draw_glyph_outline(font_rid: RID, canvas: RID, size: int, outline_size: int, pos: Vector2, index: int, color: Color) -> void:
	pass;

## [b]Optional.[/b]
## Returns font anti-aliasing mode.
func _font_get_antialiasing(font_rid: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns the font ascent (number of pixels above the baseline).
func _font_get_ascent(font_rid: RID, size: int) -> float:
	pass;

## [b]Optional.[/b]
## Returns extra baseline offset (as a fraction of font height).
func _font_get_baseline_offset(font_rid: RID) -> float:
	pass;

## [b]Required.[/b]
## Returns character code associated with [param glyph_index], or [code]0[/code] if [param glyph_index] is invalid.
func _font_get_char_from_glyph_index(font_rid: RID, size: int, glyph_index: int) -> int:
	pass;

## [b]Required.[/b]
## Returns the font descent (number of pixels below the baseline).
func _font_get_descent(font_rid: RID, size: int) -> float:
	pass;

## [b]Optional.[/b]
## Returns whether the font's embedded bitmap loading is disabled.
func _font_get_disable_embedded_bitmaps(font_rid: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Returns font embolden strength.
func _font_get_embolden(font_rid: RID) -> float:
	pass;

## [b]Optional.[/b]
## Returns number of faces in the TrueType / OpenType collection.
func _font_get_face_count(font_rid: RID) -> int:
	pass;

## [b]Optional.[/b]
## Returns an active face index in the TrueType / OpenType collection.
func _font_get_face_index(font_rid: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns bitmap font fixed size.
func _font_get_fixed_size(font_rid: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns bitmap font scaling mode.
func _font_get_fixed_size_scale_mode(font_rid: RID) -> int:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if font texture mipmap generation is enabled.
func _font_get_generate_mipmaps(font_rid: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Returns the font oversampling factor, shared by all fonts in the TextServer.
func _font_get_global_oversampling() -> float:
	pass;

## [b]Required.[/b]
## Returns glyph advance (offset of the next glyph).
func _font_get_glyph_advance(font_rid: RID, size: int, glyph: int) -> Vector2:
	pass;

## [b]Optional.[/b]
## Returns outline contours of the glyph.
func _font_get_glyph_contours(font_rid: RID, size: int, index: int) -> Dictionary:
	pass;

## [b]Required.[/b]
## Returns the glyph index of a [param char], optionally modified by the [param variation_selector].
func _font_get_glyph_index(font_rid: RID, size: int, char: int, variation_selector: int) -> int:
	pass;

## [b]Required.[/b]
## Returns list of rendered glyphs in the cache entry.
func _font_get_glyph_list(font_rid: RID, size: Vector2i) -> PackedInt32Array:
	pass;

## [b]Required.[/b]
## Returns glyph offset from the baseline.
func _font_get_glyph_offset(font_rid: RID, size: Vector2i, glyph: int) -> Vector2:
	pass;

## [b]Required.[/b]
## Returns size of the glyph.
func _font_get_glyph_size(font_rid: RID, size: Vector2i, glyph: int) -> Vector2:
	pass;

## [b]Required.[/b]
## Returns index of the cache texture containing the glyph.
func _font_get_glyph_texture_idx(font_rid: RID, size: Vector2i, glyph: int) -> int:
	pass;

## [b]Required.[/b]
## Returns resource ID of the cache texture containing the glyph.
func _font_get_glyph_texture_rid(font_rid: RID, size: Vector2i, glyph: int) -> RID:
	pass;

## [b]Required.[/b]
## Returns size of the cache texture containing the glyph.
func _font_get_glyph_texture_size(font_rid: RID, size: Vector2i, glyph: int) -> Vector2:
	pass;

## [b]Required.[/b]
## Returns rectangle in the cache texture containing the glyph.
func _font_get_glyph_uv_rect(font_rid: RID, size: Vector2i, glyph: int) -> Rect2:
	pass;

## [b]Optional.[/b]
## Returns the font hinting mode. Used by dynamic fonts only.
func _font_get_hinting(font_rid: RID) -> int:
	pass;

## [b]Optional.[/b]
## Returns glyph position rounding behavior. If set to [code]true[/code], when aligning glyphs to the pixel boundaries rounding remainders are accumulated to ensure more uniform glyph distribution. This setting has no effect if subpixel positioning is enabled.
func _font_get_keep_rounding_remainders(font_rid: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Returns kerning for the pair of glyphs.
func _font_get_kerning(font_rid: RID, size: int, glyph_pair: Vector2i) -> Vector2:
	pass;

## [b]Optional.[/b]
## Returns list of the kerning overrides.
func _font_get_kerning_list(font_rid: RID, size: int) -> Array[Vector2i]:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if support override is enabled for the [param language].
func _font_get_language_support_override(font_rid: RID, language: String) -> bool:
	pass;

## [b]Optional.[/b]
## Returns list of language support overrides.
func _font_get_language_support_overrides(font_rid: RID) -> PackedStringArray:
	pass;

## [b]Optional.[/b]
## Returns the width of the range around the shape between the minimum and maximum representable signed distance.
func _font_get_msdf_pixel_range(font_rid: RID) -> int:
	pass;

## [b]Optional.[/b]
## Returns source font size used to generate MSDF textures.
func _font_get_msdf_size(font_rid: RID) -> int:
	pass;

## [b]Optional.[/b]
## Returns font family name.
func _font_get_name(font_rid: RID) -> String:
	pass;

## [b]Optional.[/b]
## Returns font OpenType feature set override.
func _font_get_opentype_feature_overrides(font_rid: RID) -> Dictionary:
	pass;

## [b]Optional.[/b]
## Returns [Dictionary] with OpenType font name strings (localized font names, version, description, license information, sample text, etc.).
func _font_get_ot_name_strings(font_rid: RID) -> Dictionary:
	pass;

## [b]Optional.[/b]
## Returns font oversampling factor, if set to [code]0.0[/code] global oversampling factor is used instead. Used by dynamic fonts only.
func _font_get_oversampling(font_rid: RID) -> float:
	pass;

## [b]Required.[/b]
## Returns scaling factor of the color bitmap font.
func _font_get_scale(font_rid: RID, size: int) -> float:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if support override is enabled for the [param script].
func _font_get_script_support_override(font_rid: RID, script: String) -> bool:
	pass;

## [b]Optional.[/b]
## Returns list of script support overrides.
func _font_get_script_support_overrides(font_rid: RID) -> PackedStringArray:
	pass;

## [b]Required.[/b]
## Returns list of the font sizes in the cache. Each size is [Vector2i] with font size and outline size.
func _font_get_size_cache_list(font_rid: RID) -> Array[Vector2i]:
	pass;

## [b]Optional.[/b]
## Returns the spacing for [param spacing] (see [enum TextServer.SpacingType]) in pixels (not relative to the font size).
func _font_get_spacing(font_rid: RID, spacing: int) -> int:
	pass;

## [b]Optional.[/b]
## Returns font stretch amount, compared to a normal width. A percentage value between [code]50%[/code] and [code]200%[/code].
func _font_get_stretch(font_rid: RID) -> int:
	pass;

## [b]Optional.[/b]
## Returns font style flags, see [enum TextServer.FontStyle].
func _font_get_style(font_rid: RID) -> int:
	pass;

## [b]Optional.[/b]
## Returns font style name.
func _font_get_style_name(font_rid: RID) -> String:
	pass;

## [b]Optional.[/b]
## Returns font subpixel glyph positioning mode.
func _font_get_subpixel_positioning(font_rid: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns a string containing all the characters available in the font.
func _font_get_supported_chars(font_rid: RID) -> String:
	pass;

## [b]Required.[/b]
## Returns an array containing all glyph indices in the font.
func _font_get_supported_glyphs(font_rid: RID) -> PackedInt32Array:
	pass;

## [b]Required.[/b]
## Returns number of textures used by font cache entry.
func _font_get_texture_count(font_rid: RID, size: Vector2i) -> int:
	pass;

## [b]Required.[/b]
## Returns font cache texture image data.
func _font_get_texture_image(font_rid: RID, size: Vector2i, texture_index: int) -> Image:
	pass;

## [b]Optional.[/b]
## Returns array containing glyph packing data.
func _font_get_texture_offsets(font_rid: RID, size: Vector2i, texture_index: int) -> PackedInt32Array:
	pass;

## [b]Optional.[/b]
## Returns 2D transform applied to the font outlines.
func _font_get_transform(font_rid: RID) -> Transform2D:
	pass;

## [b]Required.[/b]
## Returns pixel offset of the underline below the baseline.
func _font_get_underline_position(font_rid: RID, size: int) -> float:
	pass;

## [b]Required.[/b]
## Returns thickness of the underline in pixels.
func _font_get_underline_thickness(font_rid: RID, size: int) -> float:
	pass;

## [b]Optional.[/b]
## Returns variation coordinates for the specified font cache entry.
func _font_get_variation_coordinates(font_rid: RID) -> Dictionary:
	pass;

## [b]Optional.[/b]
## Returns weight (boldness) of the font. A value in the [code]100...999[/code] range, normal font weight is [code]400[/code], bold font weight is [code]700[/code].
func _font_get_weight(font_rid: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns [code]true[/code] if a Unicode [param char] is available in the font.
func _font_has_char(font_rid: RID, char: int) -> bool:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if system fonts can be automatically used as fallbacks.
func _font_is_allow_system_fallback(font_rid: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if auto-hinting is supported and preferred over font built-in hinting.
func _font_is_force_autohinter(font_rid: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code], if font supports given language ([url=https://en.wikipedia.org/wiki/ISO_639-1]ISO 639[/url] code).
func _font_is_language_supported(font_rid: RID, language: String) -> bool:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if glyphs of all sizes are rendered using single multichannel signed distance field generated from the dynamic font vector data.
func _font_is_multichannel_signed_distance_field(font_rid: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code], if font supports given script (ISO 15924 code).
func _font_is_script_supported(font_rid: RID, script: String) -> bool:
	pass;

## [b]Required.[/b]
## Removes specified rendered glyph information from the cache entry.
func _font_remove_glyph(font_rid: RID, size: Vector2i, glyph: int) -> void:
	pass;

## [b]Optional.[/b]
## Removes kerning override for the pair of glyphs.
func _font_remove_kerning(font_rid: RID, size: int, glyph_pair: Vector2i) -> void:
	pass;

## [b]Optional.[/b]
## Remove language support override.
func _font_remove_language_support_override(font_rid: RID, language: String) -> void:
	pass;

## [b]Optional.[/b]
## Removes script support override.
func _font_remove_script_support_override(font_rid: RID, script: String) -> void:
	pass;

## [b]Required.[/b]
## Removes specified font size from the cache entry.
func _font_remove_size_cache(font_rid: RID, size: Vector2i) -> void:
	pass;

## [b]Required.[/b]
## Removes specified texture from the cache entry.
func _font_remove_texture(font_rid: RID, size: Vector2i, texture_index: int) -> void:
	pass;

## [b]Optional.[/b]
## Renders specified glyph to the font cache texture.
func _font_render_glyph(font_rid: RID, size: Vector2i, index: int) -> void:
	pass;

## [b]Optional.[/b]
## Renders the range of characters to the font cache texture.
func _font_render_range(font_rid: RID, size: Vector2i, start: int, end: int) -> void:
	pass;

## [b]Optional.[/b]
## If set to [code]true[/code], system fonts can be automatically used as fallbacks.
func _font_set_allow_system_fallback(font_rid: RID, allow_system_fallback: bool) -> void:
	pass;

## [b]Optional.[/b]
## Sets font anti-aliasing mode.
func _font_set_antialiasing(font_rid: RID, antialiasing: int) -> void:
	pass;

## [b]Required.[/b]
## Sets the font ascent (number of pixels above the baseline).
func _font_set_ascent(font_rid: RID, size: int, ascent: float) -> void:
	pass;

## [b]Optional.[/b]
## Sets extra baseline offset (as a fraction of font height).
func _font_set_baseline_offset(font_rid: RID, baseline_offset: float) -> void:
	pass;

## [b]Optional.[/b]
## Sets font source data, e.g contents of the dynamic font source file.
func _font_set_data(font_rid: RID, data: PackedByteArray) -> void:
	pass;

## [b]Optional.[/b]
## Sets pointer to the font source data, e.g contents of the dynamic font source file.
func _font_set_data_ptr(font_rid: RID, data_ptr: const uint8_t*, data_size: int) -> void:
	pass;

## [b]Required.[/b]
## Sets the font descent (number of pixels below the baseline).
func _font_set_descent(font_rid: RID, size: int, descent: float) -> void:
	pass;

## [b]Optional.[/b]
## If set to [code]true[/code], embedded font bitmap loading is disabled.
func _font_set_disable_embedded_bitmaps(font_rid: RID, disable_embedded_bitmaps: bool) -> void:
	pass;

## Sets font embolden strength. If [param strength] is not equal to zero, emboldens the font outlines. Negative values reduce the outline thickness.
func _font_set_embolden(font_rid: RID, strength: float) -> void:
	pass;

## [b]Optional.[/b]
## Sets an active face index in the TrueType / OpenType collection.
func _font_set_face_index(font_rid: RID, face_index: int) -> void:
	pass;

## [b]Required.[/b]
## Sets bitmap font fixed size. If set to value greater than zero, same cache entry will be used for all font sizes.
func _font_set_fixed_size(font_rid: RID, fixed_size: int) -> void:
	pass;

## [b]Required.[/b]
## Sets bitmap font scaling mode. This property is used only if [code]fixed_size[/code] is greater than zero.
func _font_set_fixed_size_scale_mode(font_rid: RID, fixed_size_scale_mode: int) -> void:
	pass;

## [b]Optional.[/b]
## If set to [code]true[/code] auto-hinting is preferred over font built-in hinting.
func _font_set_force_autohinter(font_rid: RID, force_autohinter: bool) -> void:
	pass;

## [b]Optional.[/b]
## If set to [code]true[/code] font texture mipmap generation is enabled.
func _font_set_generate_mipmaps(font_rid: RID, generate_mipmaps: bool) -> void:
	pass;

## [b]Optional.[/b]
## Sets oversampling factor, shared by all font in the TextServer.
func _font_set_global_oversampling(oversampling: float) -> void:
	pass;

## [b]Required.[/b]
## Sets glyph advance (offset of the next glyph).
func _font_set_glyph_advance(font_rid: RID, size: int, glyph: int, advance: Vector2) -> void:
	pass;

## [b]Required.[/b]
## Sets glyph offset from the baseline.
func _font_set_glyph_offset(font_rid: RID, size: Vector2i, glyph: int, offset: Vector2) -> void:
	pass;

## [b]Required.[/b]
## Sets size of the glyph.
func _font_set_glyph_size(font_rid: RID, size: Vector2i, glyph: int, gl_size: Vector2) -> void:
	pass;

## [b]Required.[/b]
## Sets index of the cache texture containing the glyph.
func _font_set_glyph_texture_idx(font_rid: RID, size: Vector2i, glyph: int, texture_idx: int) -> void:
	pass;

## [b]Required.[/b]
## Sets rectangle in the cache texture containing the glyph.
func _font_set_glyph_uv_rect(font_rid: RID, size: Vector2i, glyph: int, uv_rect: Rect2) -> void:
	pass;

## [b]Optional.[/b]
## Sets font hinting mode. Used by dynamic fonts only.
func _font_set_hinting(font_rid: RID, hinting: int) -> void:
	pass;

## [b]Optional.[/b]
## Sets glyph position rounding behavior. If set to [code]true[/code], when aligning glyphs to the pixel boundaries rounding remainders are accumulated to ensure more uniform glyph distribution. This setting has no effect if subpixel positioning is enabled.
func _font_set_keep_rounding_remainders(font_rid: RID, keep_rounding_remainders: bool) -> void:
	pass;

## [b]Optional.[/b]
## Sets kerning for the pair of glyphs.
func _font_set_kerning(font_rid: RID, size: int, glyph_pair: Vector2i, kerning: Vector2) -> void:
	pass;

## [b]Optional.[/b]
## Adds override for [method _font_is_language_supported].
func _font_set_language_support_override(font_rid: RID, language: String, supported: bool) -> void:
	pass;

## [b]Optional.[/b]
## Sets the width of the range around the shape between the minimum and maximum representable signed distance.
func _font_set_msdf_pixel_range(font_rid: RID, msdf_pixel_range: int) -> void:
	pass;

## [b]Optional.[/b]
## Sets source font size used to generate MSDF textures.
func _font_set_msdf_size(font_rid: RID, msdf_size: int) -> void:
	pass;

## [b]Optional.[/b]
## If set to [code]true[/code], glyphs of all sizes are rendered using single multichannel signed distance field generated from the dynamic font vector data. MSDF rendering allows displaying the font at any scaling factor without blurriness, and without incurring a CPU cost when the font size changes (since the font no longer needs to be rasterized on the CPU). As a downside, font hinting is not available with MSDF. The lack of font hinting may result in less crisp and less readable fonts at small sizes.
func _font_set_multichannel_signed_distance_field(font_rid: RID, msdf: bool) -> void:
	pass;

## [b]Optional.[/b]
## Sets the font family name.
func _font_set_name(font_rid: RID, name: String) -> void:
	pass;

## [b]Optional.[/b]
## Sets font OpenType feature set override.
func _font_set_opentype_feature_overrides(font_rid: RID, overrides: Dictionary) -> void:
	pass;

## [b]Optional.[/b]
## Sets font oversampling factor, if set to [code]0.0[/code] global oversampling factor is used instead. Used by dynamic fonts only.
func _font_set_oversampling(font_rid: RID, oversampling: float) -> void:
	pass;

## [b]Required.[/b]
## Sets scaling factor of the color bitmap font.
func _font_set_scale(font_rid: RID, size: int, scale: float) -> void:
	pass;

## [b]Optional.[/b]
## Adds override for [method _font_is_script_supported].
func _font_set_script_support_override(font_rid: RID, script: String, supported: bool) -> void:
	pass;

## [b]Optional.[/b]
## Sets the spacing for [param spacing] (see [enum TextServer.SpacingType]) to [param value] in pixels (not relative to the font size).
func _font_set_spacing(font_rid: RID, spacing: int, value: int) -> void:
	pass;

## [b]Optional.[/b]
## Sets font stretch amount, compared to a normal width. A percentage value between [code]50%[/code] and [code]200%[/code].
func _font_set_stretch(font_rid: RID, stretch: int) -> void:
	pass;

## [b]Optional.[/b]
## Sets the font style flags, see [enum TextServer.FontStyle].
func _font_set_style(font_rid: RID, style: int) -> void:
	pass;

## [b]Optional.[/b]
## Sets the font style name.
func _font_set_style_name(font_rid: RID, name_style: String) -> void:
	pass;

## [b]Optional.[/b]
## Sets font subpixel glyph positioning mode.
func _font_set_subpixel_positioning(font_rid: RID, subpixel_positioning: int) -> void:
	pass;

## [b]Required.[/b]
## Sets font cache texture image data.
func _font_set_texture_image(font_rid: RID, size: Vector2i, texture_index: int, image: Image) -> void:
	pass;

## [b]Optional.[/b]
## Sets array containing glyph packing data.
func _font_set_texture_offsets(font_rid: RID, size: Vector2i, texture_index: int, offset: PackedInt32Array) -> void:
	pass;

## [b]Optional.[/b]
## Sets 2D transform, applied to the font outlines, can be used for slanting, flipping, and rotating glyphs.
func _font_set_transform(font_rid: RID, transform: Transform2D) -> void:
	pass;

## [b]Required.[/b]
## Sets pixel offset of the underline below the baseline.
func _font_set_underline_position(font_rid: RID, size: int, underline_position: float) -> void:
	pass;

## [b]Required.[/b]
## Sets thickness of the underline in pixels.
func _font_set_underline_thickness(font_rid: RID, size: int, underline_thickness: float) -> void:
	pass;

## [b]Optional.[/b]
## Sets variation coordinates for the specified font cache entry.
func _font_set_variation_coordinates(font_rid: RID, variation_coordinates: Dictionary) -> void:
	pass;

## [b]Optional.[/b]
## Sets weight (boldness) of the font. A value in the [code]100...999[/code] range, normal font weight is [code]400[/code], bold font weight is [code]700[/code].
func _font_set_weight(font_rid: RID, weight: int) -> void:
	pass;

## [b]Optional.[/b]
## Returns the dictionary of the supported OpenType features.
func _font_supported_feature_list(font_rid: RID) -> Dictionary:
	pass;

## [b]Optional.[/b]
## Returns the dictionary of the supported OpenType variation coordinates.
func _font_supported_variation_list(font_rid: RID) -> Dictionary:
	pass;

## [b]Optional.[/b]
## Converts a number from the Western Arabic (0..9) to the numeral systems used in [param language].
func _format_number(number: String, language: String) -> String:
	pass;

## [b]Required.[/b]
## Frees an object created by this [TextServer].
func _free_rid(rid: RID) -> void:
	pass;

## [b]Required.[/b]
## Returns text server features, see [enum TextServer.Feature].
func _get_features() -> int:
	pass;

## [b]Optional.[/b]
## Returns size of the replacement character (box with character hexadecimal code that is drawn in place of invalid characters).
func _get_hex_code_box_size(size: int, index: int) -> Vector2:
	pass;

## [b]Required.[/b]
## Returns the name of the server interface.
func _get_name() -> String:
	pass;

## [b]Optional.[/b]
## Returns default TextServer database (e.g. ICU break iterators and dictionaries).
func _get_support_data() -> PackedByteArray:
	pass;

## [b]Optional.[/b]
## Returns default TextServer database (e.g. ICU break iterators and dictionaries) filename.
func _get_support_data_filename() -> String:
	pass;

## [b]Optional.[/b]
## Returns TextServer database (e.g. ICU break iterators and dictionaries) description.
func _get_support_data_info() -> String:
	pass;

## [b]Required.[/b]
## Returns [code]true[/code] if [param rid] is valid resource owned by this text server.
func _has(rid: RID) -> bool:
	pass;

## [b]Required.[/b]
## Returns [code]true[/code] if the server supports a feature.
func _has_feature(feature: int) -> bool:
	pass;

## [b]Optional.[/b]
## Returns index of the first string in [param dict] which is visually confusable with the [param string], or [code]-1[/code] if none is found.
func _is_confusable(string: String, dict: PackedStringArray) -> int:
	pass;

## [b]Required.[/b]
## Returns [code]true[/code] if locale is right-to-left.
func _is_locale_right_to_left(locale: String) -> bool:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if [param string] is a valid identifier.
func _is_valid_identifier(string: String) -> bool:
	pass;

func _is_valid_letter(unicode: int) -> bool:
	pass;

## [b]Optional.[/b]
## Loads optional TextServer database (e.g. ICU break iterators and dictionaries).
func _load_support_data(filename: String) -> bool:
	pass;

## [b]Optional.[/b]
## Converts readable feature, variation, script, or language name to OpenType tag.
func _name_to_tag(name: String) -> int:
	pass;

## [b]Optional.[/b]
## Converts [param number] from the numeral systems used in [param language] to Western Arabic (0..9).
func _parse_number(number: String, language: String) -> String:
	pass;

## [b]Optional.[/b]
## Default implementation of the BiDi algorithm override function. See [enum TextServer.StructuredTextParser] for more info.
func _parse_structured_text(parser_type: int, args: Array, text: String) -> Array[Vector3i]:
	pass;

## [b]Optional.[/b]
## Returns percent sign used in the [param language].
func _percent_sign(language: String) -> String:
	pass;

## [b]Optional.[/b]
## Saves optional TextServer database (e.g. ICU break iterators and dictionaries) to the file.
func _save_support_data(filename: String) -> bool:
	pass;

## [b]Required.[/b]
## Returns number of text spans added using [method _shaped_text_add_string] or [method _shaped_text_add_object].
func _shaped_get_span_count(shaped: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns text embedded object key.
func _shaped_get_span_embedded_object(shaped: RID, index: int) -> Variant:
	pass;

## [b]Required.[/b]
## Returns text span metadata.
func _shaped_get_span_meta(shaped: RID, index: int) -> Variant:
	pass;

## [b]Required.[/b]
## Changes text span font, font size, and OpenType features, without changing the text.
func _shaped_set_span_update_font(shaped: RID, index: int, fonts: Array[RID], size: int, opentype_features: Dictionary) -> void:
	pass;

## [b]Required.[/b]
## Adds inline object to the text buffer, [param key] must be unique. In the text, object is represented as [param length] object replacement characters.
func _shaped_text_add_object(shaped: RID, key: Variant, size: Vector2, inline_align: int, length: int, baseline: float) -> bool:
	pass;

## [b]Required.[/b]
## Adds text span and font to draw it to the text buffer.
func _shaped_text_add_string(shaped: RID, text: String, fonts: Array[RID], size: int, opentype_features: Dictionary, language: String, meta: Variant) -> bool:
	pass;

## [b]Required.[/b]
## Clears text buffer (removes text and inline objects).
func _shaped_text_clear(shaped: RID) -> void:
	pass;

## [b]Optional.[/b]
## Returns composite character position closest to the [param pos].
func _shaped_text_closest_character_pos(shaped: RID, pos: int) -> int:
	pass;

## [b]Optional.[/b]
## Draw shaped text into a canvas item at a given position, with [param color]. [param pos] specifies the leftmost point of the baseline (for horizontal layout) or topmost point of the baseline (for vertical layout).
func _shaped_text_draw(shaped: RID, canvas: RID, pos: Vector2, clip_l: float, clip_r: float, color: Color) -> void:
	pass;

## [b]Optional.[/b]
## Draw the outline of the shaped text into a canvas item at a given position, with [param color]. [param pos] specifies the leftmost point of the baseline (for horizontal layout) or topmost point of the baseline (for vertical layout).
func _shaped_text_draw_outline(shaped: RID, canvas: RID, pos: Vector2, clip_l: float, clip_r: float, outline_size: int, color: Color) -> void:
	pass;

## [b]Optional.[/b]
## Adjusts text width to fit to specified width, returns new text width.
func _shaped_text_fit_to_width(shaped: RID, width: float, justification_flags: int) -> float:
	pass;

## [b]Required.[/b]
## Returns the text ascent (number of pixels above the baseline for horizontal layout or to the left of baseline for vertical).
func _shaped_text_get_ascent(shaped: RID) -> float:
	pass;

## [b]Optional.[/b]
## Returns shapes of the carets corresponding to the character offset [param position] in the text. Returned caret shape is 1 pixel wide rectangle.
func _shaped_text_get_carets(shaped: RID, position: int, caret: CaretInfo*) -> void:
	pass;

## [b]Optional.[/b]
## Returns array of the composite character boundaries.
func _shaped_text_get_character_breaks(shaped: RID) -> PackedInt32Array:
	pass;

## [b]Optional.[/b]
## Returns ellipsis character used for text clipping.
func _shaped_text_get_custom_ellipsis(shaped: RID) -> int:
	pass;

## [b]Optional.[/b]
## Returns custom punctuation character list, used for word breaking. If set to empty string, server defaults are used.
func _shaped_text_get_custom_punctuation(shaped: RID) -> String:
	pass;

## [b]Required.[/b]
## Returns the text descent (number of pixels below the baseline for horizontal layout or to the right of baseline for vertical).
func _shaped_text_get_descent(shaped: RID) -> float:
	pass;

## [b]Optional.[/b]
## Returns direction of the text.
func _shaped_text_get_direction(shaped: RID) -> int:
	pass;

## [b]Optional.[/b]
## Returns dominant direction of in the range of text.
func _shaped_text_get_dominant_direction_in_range(shaped: RID, start: int, end: int) -> int:
	pass;

## [b]Required.[/b]
## Returns number of glyphs in the ellipsis.
func _shaped_text_get_ellipsis_glyph_count(shaped: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns array of the glyphs in the ellipsis.
func _shaped_text_get_ellipsis_glyphs(shaped: RID) -> const Glyph*:
	pass;

## [b]Required.[/b]
## Returns position of the ellipsis.
func _shaped_text_get_ellipsis_pos(shaped: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns number of glyphs in the buffer.
func _shaped_text_get_glyph_count(shaped: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns an array of glyphs in the visual order.
func _shaped_text_get_glyphs(shaped: RID) -> const Glyph*:
	pass;

## [b]Optional.[/b]
## Returns composite character's bounds as offsets from the start of the line.
func _shaped_text_get_grapheme_bounds(shaped: RID, pos: int) -> Vector2:
	pass;

## [b]Optional.[/b]
## Returns direction of the text, inferred by the BiDi algorithm.
func _shaped_text_get_inferred_direction(shaped: RID) -> int:
	pass;

## [b]Optional.[/b]
## Breaks text to the lines and returns character ranges for each line.
func _shaped_text_get_line_breaks(shaped: RID, width: float, start: int, break_flags: int) -> PackedInt32Array:
	pass;

## [b]Optional.[/b]
## Breaks text to the lines and columns. Returns character ranges for each segment.
func _shaped_text_get_line_breaks_adv(shaped: RID, width: PackedFloat32Array, start: int, once: bool, break_flags: int) -> PackedInt32Array:
	pass;

## [b]Required.[/b]
## Returns the glyph index of the inline object.
func _shaped_text_get_object_glyph(shaped: RID, key: Variant) -> int:
	pass;

## [b]Required.[/b]
## Returns the character range of the inline object.
func _shaped_text_get_object_range(shaped: RID, key: Variant) -> Vector2i:
	pass;

## [b]Required.[/b]
## Returns bounding rectangle of the inline object.
func _shaped_text_get_object_rect(shaped: RID, key: Variant) -> Rect2:
	pass;

## [b]Required.[/b]
## Returns array of inline objects.
func _shaped_text_get_objects(shaped: RID) -> Array:
	pass;

## [b]Optional.[/b]
## Returns text orientation.
func _shaped_text_get_orientation(shaped: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns the parent buffer from which the substring originates.
func _shaped_text_get_parent(shaped: RID) -> RID:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if text buffer is configured to display control characters.
func _shaped_text_get_preserve_control(shaped: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if text buffer is configured to display hexadecimal codes in place of invalid characters.
func _shaped_text_get_preserve_invalid(shaped: RID) -> bool:
	pass;

## [b]Required.[/b]
## Returns substring buffer character range in the parent buffer.
func _shaped_text_get_range(shaped: RID) -> Vector2i:
	pass;

## [b]Optional.[/b]
## Returns selection rectangles for the specified character range.
func _shaped_text_get_selection(shaped: RID, start: int, end: int) -> PackedVector2Array:
	pass;

## [b]Required.[/b]
## Returns size of the text.
func _shaped_text_get_size(shaped: RID) -> Vector2:
	pass;

## [b]Optional.[/b]
## Returns extra spacing added between glyphs or lines in pixels.
func _shaped_text_get_spacing(shaped: RID, spacing: int) -> int:
	pass;

## [b]Required.[/b]
## Returns the position of the overrun trim.
func _shaped_text_get_trim_pos(shaped: RID) -> int:
	pass;

## [b]Required.[/b]
## Returns pixel offset of the underline below the baseline.
func _shaped_text_get_underline_position(shaped: RID) -> float:
	pass;

## [b]Required.[/b]
## Returns thickness of the underline.
func _shaped_text_get_underline_thickness(shaped: RID) -> float:
	pass;

## [b]Required.[/b]
## Returns width (for horizontal layout) or height (for vertical) of the text.
func _shaped_text_get_width(shaped: RID) -> float:
	pass;

## [b]Optional.[/b]
## Breaks text into words and returns array of character ranges. Use [param grapheme_flags] to set what characters are used for breaking (see [enum TextServer.GraphemeFlag]).
func _shaped_text_get_word_breaks(shaped: RID, grapheme_flags: int, skip_grapheme_flags: int) -> PackedInt32Array:
	pass;

## [b]Optional.[/b]
## Returns grapheme index at the specified pixel offset at the baseline, or [code]-1[/code] if none is found.
func _shaped_text_hit_test_grapheme(shaped: RID, coord: float) -> int:
	pass;

## [b]Optional.[/b]
## Returns caret character offset at the specified pixel offset at the baseline. This function always returns a valid position.
func _shaped_text_hit_test_position(shaped: RID, coord: float) -> int:
	pass;

## [b]Required.[/b]
## Returns [code]true[/code] if buffer is successfully shaped.
func _shaped_text_is_ready(shaped: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Returns composite character end position closest to the [param pos].
func _shaped_text_next_character_pos(shaped: RID, pos: int) -> int:
	pass;

## [b]Optional.[/b]
## Returns grapheme end position closest to the [param pos].
func _shaped_text_next_grapheme_pos(shaped: RID, pos: int) -> int:
	pass;

## [b]Optional.[/b]
## Trims text if it exceeds the given width.
func _shaped_text_overrun_trim_to_width(shaped: RID, width: float, trim_flags: int) -> void:
	pass;

## [b]Optional.[/b]
## Returns composite character start position closest to the [param pos].
func _shaped_text_prev_character_pos(shaped: RID, pos: int) -> int:
	pass;

## [b]Optional.[/b]
## Returns grapheme start position closest to the [param pos].
func _shaped_text_prev_grapheme_pos(shaped: RID, pos: int) -> int:
	pass;

## [b]Required.[/b]
## Sets new size and alignment of embedded object.
func _shaped_text_resize_object(shaped: RID, key: Variant, size: Vector2, inline_align: int, baseline: float) -> bool:
	pass;

## [b]Optional.[/b]
## Overrides BiDi for the structured text.
func _shaped_text_set_bidi_override(shaped: RID, override: Array) -> void:
	pass;

## [b]Optional.[/b]
## Sets ellipsis character used for text clipping.
func _shaped_text_set_custom_ellipsis(shaped: RID, char: int) -> void:
	pass;

## [b]Optional.[/b]
## Sets custom punctuation character list, used for word breaking. If set to empty string, server defaults are used.
func _shaped_text_set_custom_punctuation(shaped: RID, punct: String) -> void:
	pass;

## [b]Optional.[/b]
## Sets desired text direction. If set to [constant TextServer.DIRECTION_AUTO], direction will be detected based on the buffer contents and current locale.
func _shaped_text_set_direction(shaped: RID, direction: int) -> void:
	pass;

## [b]Optional.[/b]
## Sets desired text orientation.
func _shaped_text_set_orientation(shaped: RID, orientation: int) -> void:
	pass;

## [b]Optional.[/b]
## If set to [code]true[/code] text buffer will display control characters.
func _shaped_text_set_preserve_control(shaped: RID, enabled: bool) -> void:
	pass;

## [b]Optional.[/b]
## If set to [code]true[/code] text buffer will display invalid characters as hexadecimal codes, otherwise nothing is displayed.
func _shaped_text_set_preserve_invalid(shaped: RID, enabled: bool) -> void:
	pass;

## [b]Optional.[/b]
## Sets extra spacing added between glyphs or lines in pixels.
func _shaped_text_set_spacing(shaped: RID, spacing: int, value: int) -> void:
	pass;

## [b]Required.[/b]
## Shapes buffer if it's not shaped. Returns [code]true[/code] if the string is shaped successfully.
func _shaped_text_shape(shaped: RID) -> bool:
	pass;

## [b]Required.[/b]
## Returns text glyphs in the logical order.
func _shaped_text_sort_logical(shaped: RID) -> const Glyph*:
	pass;

## [b]Required.[/b]
## Returns text buffer for the substring of the text in the [param shaped] text buffer (including inline objects).
func _shaped_text_substr(shaped: RID, start: int, length: int) -> RID:
	pass;

## [b]Optional.[/b]
## Aligns shaped text to the given tab-stops.
func _shaped_text_tab_align(shaped: RID, tab_stops: PackedFloat32Array) -> float:
	pass;

## [b]Optional.[/b]
## Updates break points in the shaped text. This method is called by default implementation of text breaking functions.
func _shaped_text_update_breaks(shaped: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Updates justification points in the shaped text. This method is called by default implementation of text justification functions.
func _shaped_text_update_justification_ops(shaped: RID) -> bool:
	pass;

## [b]Optional.[/b]
## Returns [code]true[/code] if [param string] is likely to be an attempt at confusing the reader.
func _spoof_check(string: String) -> bool:
	pass;

## [b]Optional.[/b]
## Returns array of the composite character boundaries.
func _string_get_character_breaks(string: String, language: String) -> PackedInt32Array:
	pass;

## [b]Optional.[/b]
## Returns an array of the word break boundaries. Elements in the returned array are the offsets of the start and end of words. Therefore the length of the array is always even.
func _string_get_word_breaks(string: String, language: String, chars_per_line: int) -> PackedInt32Array:
	pass;

## [b]Optional.[/b]
## Returns the string converted to lowercase.
func _string_to_lower(string: String, language: String) -> String:
	pass;

## [b]Optional.[/b]
## Returns the string converted to title case.
func _string_to_title(string: String, language: String) -> String:
	pass;

## [b]Optional.[/b]
## Returns the string converted to uppercase.
func _string_to_upper(string: String, language: String) -> String:
	pass;

## [b]Optional.[/b]
## Strips diacritics from the string.
func _strip_diacritics(string: String) -> String:
	pass;

## [b]Optional.[/b]
## Converts OpenType tag to readable feature, variation, script, or language name.
func _tag_to_name(tag: int) -> String:
	pass;


