extends RefCounted
class_name TLSOptions

## TLS configuration for clients and servers.
##
## TLSOptions abstracts the configuration options for the [StreamPeerTLS] and [PacketPeerDTLS] classes.
## Objects of this class cannot be instantiated directly, and one of the static methods [method client], [method client_unsafe], or [method server] should be used instead.
## [codeblocks]
## [gdscript]
## # Create a TLS client configuration which uses our custom trusted CA chain.
## var client_trusted_cas = load("res://my_trusted_cas.crt")
## var client_tls_options = TLSOptions.client(client_trusted_cas)
## # Create a TLS server configuration.
## var server_certs = load("res://my_server_cas.crt")
## var server_key = load("res://my_server_key.key")
## var server_tls_options = TLSOptions.server(server_key, server_certs)
## [/gdscript]
## [/codeblocks]





## Creates a TLS client configuration which validates certificates and their common names (fully qualified domain names).
## You can specify a custom [param trusted_chain] of certification authorities (the default CA list will be used if [code]null[/code]), and optionally provide a [param common_name_override] if you expect the certificate to have a common name other than the server FQDN.
## [b]Note:[/b] On the Web platform, TLS verification is always enforced against the CA list of the web browser. This is considered a security feature.
static func client(trusted_chain: X509Certificate = null, common_name_override: String = "") -> TLSOptions:
	pass;

## Creates an [b]unsafe[/b] TLS client configuration where certificate validation is optional. You can optionally provide a valid [param trusted_chain], but the common name of the certificates will never be checked. Using this configuration for purposes other than testing [b]is not recommended[/b].
## [b]Note:[/b] On the Web platform, TLS verification is always enforced against the CA list of the web browser. This is considered a security feature.
static func client_unsafe(trusted_chain: X509Certificate = null) -> TLSOptions:
	pass;

## Returns the common name (domain name) override specified when creating with [method TLSOptions.client].
func get_common_name_override() -> String:
	pass;

## Returns the [X509Certificate] specified when creating with [method TLSOptions.server].
func get_own_certificate() -> X509Certificate:
	pass;

## Returns the [CryptoKey] specified when creating with [method TLSOptions.server].
func get_private_key() -> CryptoKey:
	pass;

## Returns the CA [X509Certificate] chain specified when creating with [method TLSOptions.client] or [method TLSOptions.client_unsafe].
func get_trusted_ca_chain() -> X509Certificate:
	pass;

## Returns [code]true[/code] if created with [method TLSOptions.server], [code]false[/code] otherwise.
func is_server() -> bool:
	pass;

## Returns [code]true[/code] if created with [method TLSOptions.client_unsafe], [code]false[/code] otherwise.
func is_unsafe_client() -> bool:
	pass;

## Creates a TLS server configuration using the provided [param key] and [param certificate].
## [b]Note:[/b] The [param certificate] should include the full certificate chain up to the signing CA (certificates file can be concatenated using a general purpose text editor).
static func server(key: CryptoKey, certificate: X509Certificate) -> TLSOptions:
	pass;


