extends RefCounted
class_name StreamPeer

## Abstract base class for interacting with streams.
##
## StreamPeer is an abstract base class mostly used for stream-based protocols (such as TCP). It provides an API for sending and receiving data through streams as raw data or strings.
## [b]Note:[/b] When exporting to Android, make sure to enable the [code]INTERNET[/code] permission in the Android export preset before exporting the project or using one-click deploy. Otherwise, network communication of any kind will be blocked by Android.



## If [code]true[/code], this [StreamPeer] will using big-endian format for encoding and decoding.
var big_endian: bool:
	get = is_big_endian_enabled, set = set_big_endian



## Gets a signed byte from the stream.
func get_8() -> int:
	pass;

## Gets a signed 16-bit value from the stream.
func get_16() -> int:
	pass;

## Gets a signed 32-bit value from the stream.
func get_32() -> int:
	pass;

## Gets a signed 64-bit value from the stream.
func get_64() -> int:
	pass;

## Returns the number of bytes this [StreamPeer] has available.
func get_available_bytes() -> int:
	pass;

## Returns a chunk data with the received bytes. The number of bytes to be received can be requested in the [param bytes] argument. If not enough bytes are available, the function will block until the desired amount is received. This function returns two values, an [enum Error] code and a data array.
func get_data(bytes: int) -> Array:
	pass;

## Gets a double-precision float from the stream.
func get_double() -> float:
	pass;

## Gets a single-precision float from the stream.
func get_float() -> float:
	pass;

## Gets a half-precision float from the stream.
func get_half() -> float:
	pass;

## Returns a chunk data with the received bytes. The number of bytes to be received can be requested in the "bytes" argument. If not enough bytes are available, the function will return how many were actually received. This function returns two values, an [enum Error] code, and a data array.
func get_partial_data(bytes: int) -> Array:
	pass;

## Gets an ASCII string with byte-length [param bytes] from the stream. If [param bytes] is negative (default) the length will be read from the stream using the reverse process of [method put_string].
func get_string(bytes: int = -1) -> String:
	pass;

## Gets an unsigned byte from the stream.
func get_u8() -> int:
	pass;

## Gets an unsigned 16-bit value from the stream.
func get_u16() -> int:
	pass;

## Gets an unsigned 32-bit value from the stream.
func get_u32() -> int:
	pass;

## Gets an unsigned 64-bit value from the stream.
func get_u64() -> int:
	pass;

## Gets a UTF-8 string with byte-length [param bytes] from the stream (this decodes the string sent as UTF-8). If [param bytes] is negative (default) the length will be read from the stream using the reverse process of [method put_utf8_string].
func get_utf8_string(bytes: int = -1) -> String:
	pass;

## Gets a Variant from the stream. If [param allow_objects] is [code]true[/code], decoding objects is allowed.
## Internally, this uses the same decoding mechanism as the [method @GlobalScope.bytes_to_var] method.
## [b]Warning:[/b] Deserialized objects can contain code which gets executed. Do not use this option if the serialized object comes from untrusted sources to avoid potential security threats such as remote code execution.
func get_var(allow_objects: bool = false) -> Variant:
	pass;

## Puts a signed byte into the stream.
func put_8(value: int) -> void:
	pass;

## Puts a signed 16-bit value into the stream.
func put_16(value: int) -> void:
	pass;

## Puts a signed 32-bit value into the stream.
func put_32(value: int) -> void:
	pass;

## Puts a signed 64-bit value into the stream.
func put_64(value: int) -> void:
	pass;

## Sends a chunk of data through the connection, blocking if necessary until the data is done sending. This function returns an [enum Error] code.
func put_data(data: PackedByteArray) -> int:
	pass;

## Puts a double-precision float into the stream.
func put_double(value: float) -> void:
	pass;

## Puts a single-precision float into the stream.
func put_float(value: float) -> void:
	pass;

## Puts a half-precision float into the stream.
func put_half(value: float) -> void:
	pass;

## Sends a chunk of data through the connection. If all the data could not be sent at once, only part of it will. This function returns two values, an [enum Error] code and an integer, describing how much data was actually sent.
func put_partial_data(data: PackedByteArray) -> Array:
	pass;

## Puts a zero-terminated ASCII string into the stream prepended by a 32-bit unsigned integer representing its size.
## [b]Note:[/b] To put an ASCII string without prepending its size, you can use [method put_data]:
## [codeblocks]
## [gdscript]
## put_data("Hello world".to_ascii_buffer())
## [/gdscript]
## [csharp]
## PutData("Hello World".ToAsciiBuffer());
## [/csharp]
## [/codeblocks]
func put_string(value: String) -> void:
	pass;

## Puts an unsigned byte into the stream.
func put_u8(value: int) -> void:
	pass;

## Puts an unsigned 16-bit value into the stream.
func put_u16(value: int) -> void:
	pass;

## Puts an unsigned 32-bit value into the stream.
func put_u32(value: int) -> void:
	pass;

## Puts an unsigned 64-bit value into the stream.
func put_u64(value: int) -> void:
	pass;

## Puts a zero-terminated UTF-8 string into the stream prepended by a 32 bits unsigned integer representing its size.
## [b]Note:[/b] To put a UTF-8 string without prepending its size, you can use [method put_data]:
## [codeblocks]
## [gdscript]
## put_data("Hello world".to_utf8_buffer())
## [/gdscript]
## [csharp]
## PutData("Hello World".ToUtf8Buffer());
## [/csharp]
## [/codeblocks]
func put_utf8_string(value: String) -> void:
	pass;

## Puts a Variant into the stream. If [param full_objects] is [code]true[/code] encoding objects is allowed (and can potentially include code).
## Internally, this uses the same encoding mechanism as the [method @GlobalScope.var_to_bytes] method.
func put_var(value: Variant, full_objects: bool = false) -> void:
	pass;


func is_big_endian_enabled() -> bool:
	return big_endian

func set_big_endian(value: bool) -> void:
	big_endian = value

