extends Node3D
class_name SpringBoneCollision3D

## A base class of the collision that interacts with [SpringBoneSimulator3D].
##
## A collision can be a child of [SpringBoneSimulator3D]. If it is not a child of [SpringBoneSimulator3D], it has no effect.
## The colliding and sliding are done in the [SpringBoneSimulator3D]'s modification process in order of its collision list which is set by [method SpringBoneSimulator3D.set_collision_path]. If [method SpringBoneSimulator3D.are_all_child_collisions_enabled] is [code]true[/code], the order matches [SceneTree].
## If [member bone] is set, it synchronizes with the bone pose of the ancestor [Skeleton3D], which is done in before the [SpringBoneSimulator3D]'s modification process as the pre-process.
## [b]Warning:[/b] A scaled [SpringBoneCollision3D] will likely not behave as expected. Make sure that the parent [Skeleton3D] and its bones are not scaled.



## The index of the attached bone.
var bone: int:
	get = get_bone, set = set_bone

## The name of the attached bone.
var bone_name: String:
	get = get_bone_name, set = set_bone_name

## The offset of the position from [Skeleton3D]'s [member bone] pose position.
var position_offset: Vector3:
	get = get_position_offset, set = set_position_offset

## The offset of the rotation from [Skeleton3D]'s [member bone] pose rotation.
var rotation_offset: Quaternion:
	get = get_rotation_offset, set = set_rotation_offset



## Get parent [Skeleton3D] node of the parent [SpringBoneSimulator3D] if found.
func get_skeleton() -> Skeleton3D:
	pass;


func get_bone() -> int:
	return bone

func set_bone(value: int) -> void:
	bone = value

func get_bone_name() -> String:
	return bone_name

func set_bone_name(value: String) -> void:
	bone_name = value

func get_position_offset() -> Vector3:
	return position_offset

func set_position_offset(value: Vector3) -> void:
	position_offset = value

func get_rotation_offset() -> Quaternion:
	return rotation_offset

func set_rotation_offset(value: Quaternion) -> void:
	rotation_offset = value

