extends Object
class_name ShaderIncludeDB

## Internal database of built in shader include files.
##
## This object contains shader fragments from Godot's internal shaders. These can be used when access to internal uniform buffers and/or internal functions is required for instance when composing compositor effects or compute shaders. Only fragments for the current rendering device are loaded.





## Returns the code for the built-in shader fragment. You can also access this in your shader code through [code]#include "filename"[/code].
static func get_built_in_include_file(filename: String) -> String:
	pass;

## Returns [code]true[/code] if an include file with this name exists.
static func has_built_in_include_file(filename: String) -> bool:
	pass;

## Returns a list of built-in include files that are currently registered.
static func list_built_in_include_files() -> PackedStringArray:
	pass;


