extends Resource
class_name Shader

## A shader implemented in the Godot shading language.
##
## A custom shader program implemented in the Godot shading language, saved with the [code].gdshader[/code] extension.
## This class is used by a [ShaderMaterial] and allows you to write your own custom behavior for rendering visual items or updating particle information. For a detailed explanation and usage, please see the tutorials linked below.
##
## @tutorial(Shaders documentation index): https://docs.godotengine.org/en/stable/tutorials/shaders/index.html


## Mode used to draw all 3D objects.
## Mode used to draw all 2D objects.
## Mode used to calculate particle information on a per-particle basis. Not used for drawing.
## Mode used for drawing skies. Only works with shaders attached to [Sky] objects.
## Mode used for setting the color and density of volumetric fog effect.

#enum Mode
enum {
    MODE_SPATIAL = 0,
    MODE_CANVAS_ITEM = 1,
    MODE_PARTICLES = 2,
    MODE_SKY = 3,
    MODE_FOG = 4,
}
## Returns the shader's code as the user has written it, not the full generated code used internally.
var code: String:
	get = get_code, set = set_code



## Returns the texture that is set as default for the specified parameter.
## [b]Note:[/b] [param name] must match the name of the uniform in the code exactly.
## [b]Note:[/b] If the sampler array is used use [param index] to access the specified texture.
func get_default_texture_parameter(name: StringName, index: int = 0) -> Texture:
	pass;

## Returns the shader mode for the shader.
func get_mode() -> int:
	pass;

## Returns the list of shader uniforms that can be assigned to a [ShaderMaterial], for use with [method ShaderMaterial.set_shader_parameter] and [method ShaderMaterial.get_shader_parameter]. The parameters returned are contained in dictionaries in a similar format to the ones returned by [method Object.get_property_list].
## If argument [param get_groups] is [code]true[/code], parameter grouping hints are also included in the list.
func get_shader_uniform_list(get_groups: bool = false) -> Array:
	pass;

## Only available when running in the editor. Opens a popup that visualizes the generated shader code, including all variants and internal shader code. See also [method Material.inspect_native_shader_code].
func inspect_native_shader_code() -> void:
	pass;

## Sets the default texture to be used with a texture uniform. The default is used if a texture is not set in the [ShaderMaterial].
## [b]Note:[/b] [param name] must match the name of the uniform in the code exactly.
## [b]Note:[/b] If the sampler array is used use [param index] to access the specified texture.
func set_default_texture_parameter(name: StringName, texture: Texture, index: int = 0) -> void:
	pass;


func get_code() -> String:
	return code

func set_code(value: String) -> void:
	code = value

