extends Resource
class_name Script

## A class stored as a resource.
##
## A class stored as a resource. A script extends the functionality of all objects that instantiate it.
## This is the base class for all scripts and should not be used directly. Trying to create a new script with this class will result in an error.
## The [code]new[/code] method of a script subclass creates a new instance. [method Object.set_script] extends an existing object, if that object's class matches one of the script's base classes.
##
## @tutorial(Scripting documentation index): https://docs.godotengine.org/en/stable/tutorials/scripting/index.html



## The script source code or an empty string if source code is not available. When set, does not reload the class implementation automatically.
var source_code: String:
	get = get_source_code, set = set_source_code



## Returns [code]true[/code] if the script can be instantiated.
func can_instantiate() -> bool:
	pass;

## Returns the script directly inherited by this script.
func get_base_script() -> Script:
	pass;

## Returns the class name associated with the script, if there is one. Returns an empty string otherwise.
## To give the script a global name, you can use the [code]class_name[/code] keyword in GDScript and the [code][GlobalClass][/code] attribute in C#.
## [codeblocks]
## [gdscript]
## class_name MyNode
## extends Node
## [/gdscript]
## [csharp]
## using Godot;
## [GlobalClass]
## public partial class MyNode : Node
## {
## }
## [/csharp]
## [/codeblocks]
func get_global_name() -> StringName:
	pass;

## Returns the script's base type.
func get_instance_base_type() -> StringName:
	pass;

## Returns the default value of the specified property.
func get_property_default_value(property: StringName) -> Variant:
	pass;

## Returns a [Dictionary] mapping method names to their RPC configuration defined by this script.
func get_rpc_config() -> Variant:
	pass;

## Returns a dictionary containing constant names and their values.
func get_script_constant_map() -> Dictionary:
	pass;

## Returns the list of methods in this [Script].
func get_script_method_list() -> Array[Dictionary]:
	pass;

## Returns the list of properties in this [Script].
func get_script_property_list() -> Array[Dictionary]:
	pass;

## Returns the list of user signals defined in this [Script].
func get_script_signal_list() -> Array[Dictionary]:
	pass;

## Returns [code]true[/code] if the script, or a base class, defines a signal with the given name.
func has_script_signal(signal_name: StringName) -> bool:
	pass;

## Returns [code]true[/code] if the script contains non-empty source code.
## [b]Note:[/b] If a script does not have source code, this does not mean that it is invalid or unusable. For example, a [GDScript] that was exported with binary tokenization has no source code, but still behaves as expected and could be instantiated. This can be checked with [method can_instantiate].
func has_source_code() -> bool:
	pass;

## Returns [code]true[/code] if [param base_object] is an instance of this script.
func instance_has(base_object: Object) -> bool:
	pass;

## Returns [code]true[/code] if the script is an abstract script. An abstract script does not have a constructor and cannot be instantiated.
func is_abstract() -> bool:
	pass;

## Returns [code]true[/code] if the script is a tool script. A tool script can run in the editor.
func is_tool() -> bool:
	pass;

## Reloads the script's class implementation. Returns an error code.
func reload(keep_state: bool = false) -> int:
	pass;


func get_source_code() -> String:
	return source_code

func set_source_code(value: String) -> void:
	source_code = value

