extends PrimitiveMesh
class_name RibbonTrailMesh

## Represents a straight ribbon-shaped [PrimitiveMesh] with variable width.
##
## [RibbonTrailMesh] represents a straight ribbon-shaped mesh with variable width. The ribbon is composed of a number of flat or cross-shaped sections, each with the same [member section_length] and number of [member section_segments]. A [member curve] is sampled along the total length of the ribbon, meaning that the curve determines the size of the ribbon along its length.
## This primitive mesh is usually used for particle trails.
##
## @tutorial(3D Particle trails): https://docs.godotengine.org/en/stable/tutorials/3d/particles/trails.html
## @tutorial(Particle systems (3D)): https://docs.godotengine.org/en/stable/tutorials/3d/particles/index.html


## Gives the mesh a single flat face.
## Gives the mesh two perpendicular flat faces, making a cross shape.

#enum Shape
enum {
    SHAPE_FLAT = 0,
    SHAPE_CROSS = 1,
}
## Determines the size of the ribbon along its length. The size of a particular section segment is obtained by multiplying the baseline [member size] by the value of this curve at the given distance. For values smaller than [code]0[/code], the faces will be inverted. Should be a unit [Curve].
var curve: Curve:
	get = get_curve, set = set_curve

## The length of a section of the ribbon.
var section_length: float:
	get = get_section_length, set = set_section_length

## The number of segments in a section. The [member curve] is sampled on each segment to determine its size. Higher values result in a more detailed ribbon at the cost of performance.
var section_segments: int:
	get = get_section_segments, set = set_section_segments

## The total number of sections on the ribbon.
var sections: int:
	get = get_sections, set = set_sections

## Determines the shape of the ribbon.
var shape: int:
	get = get_shape, set = set_shape

## The baseline size of the ribbon. The size of a particular section segment is obtained by multiplying this size by the value of the [member curve] at the given distance.
var size: float:
	get = get_size, set = set_size




func get_curve() -> Curve:
	return curve

func set_curve(value: Curve) -> void:
	curve = value

func get_section_length() -> float:
	return section_length

func set_section_length(value: float) -> void:
	section_length = value

func get_section_segments() -> int:
	return section_segments

func set_section_segments(value: int) -> void:
	section_segments = value

func get_sections() -> int:
	return sections

func set_sections(value: int) -> void:
	sections = value

func get_shape() -> int:
	return shape

func set_shape(value: int) -> void:
	shape = value

func get_size() -> float:
	return size

func set_size(value: float) -> void:
	size = value

