extends ResourceImporter
class_name ResourceImporterOggVorbis

## Imports an Ogg Vorbis audio file for playback.
##
## Ogg Vorbis is a lossy audio format, with better audio quality compared to [ResourceImporterMP3] at a given bitrate.
## In most cases, it's recommended to use Ogg Vorbis over MP3. However, if you're using an MP3 sound source with no higher quality source available, then it's recommended to use the MP3 file directly to avoid double lossy compression.
## Ogg Vorbis requires more CPU to decode than [ResourceImporterWAV]. If you need to play a lot of simultaneous sounds, it's recommended to use WAV for those sounds instead, especially if targeting low-end devices.
##
## @tutorial(Importing audio samples): https://docs.godotengine.org/en/stable/tutorials/assets_pipeline/importing_audio_samples.html



## The number of bars within a single beat in the audio track. This is only relevant for music that wishes to make use of interactive music functionality, not sound effects.
## A more convenient editor for [member bar_beats] is provided in the [b]Advanced Import Settings[/b] dialog, as it lets you preview your changes without having to reimport the audio.
var bar_beats: int

## The beat count of the audio track. This is only relevant for music that wishes to make use of interactive music functionality, not sound effects.
## A more convenient editor for [member beat_count] is provided in the [b]Advanced Import Settings[/b] dialog, as it lets you preview your changes without having to reimport the audio.
var beat_count: int

## The beats per minute of the audio track. This should match the BPM measure that was used to compose the track. This is only relevant for music that wishes to make use of interactive music functionality, not sound effects.
## A more convenient editor for [member bpm] is provided in the [b]Advanced Import Settings[/b] dialog, as it lets you preview your changes without having to reimport the audio.
var bpm: float

## If enabled, the audio will begin playing at the beginning after playback ends by reaching the end of the audio.
## [b]Note:[/b] In [AudioStreamPlayer], the [signal AudioStreamPlayer.finished] signal won't be emitted for looping audio when it reaches the end of the audio file, as the audio will keep playing indefinitely.
var loop: bool

## Determines where audio will start to loop after playback reaches the end of the audio. This can be used to only loop a part of the audio file, which is useful for some ambient sounds or music. The value is determined in seconds relative to the beginning of the audio. A value of [code]0.0[/code] will loop the entire audio file.
## Only has an effect if [member loop] is [code]true[/code].
## A more convenient editor for [member loop_offset] is provided in the [b]Advanced Import Settings[/b] dialog, as it lets you preview your changes without having to reimport the audio.
var loop_offset: float



## Creates a new [AudioStreamOggVorbis] instance from the given buffer. The buffer must contain Ogg Vorbis data.
static func load_from_buffer(stream_data: PackedByteArray) -> AudioStreamOggVorbis:
	pass;

## Creates a new [AudioStreamOggVorbis] instance from the given file path. The file must be in Ogg Vorbis format.
static func load_from_file(path: String) -> AudioStreamOggVorbis:
	pass;


