extends Popup
class_name PopupPanel

## A popup with a panel background.
##
## A popup with a configurable panel background. Any child controls added to this node will be stretched to fit the panel's size (similar to how [PanelContainer] works). If you are making windows, see [Window].



var transparent: bool:
	get = get_flag, set = set_flag

var transparent_bg: bool:
	get = has_transparent_background, set = set_transparent_background




func get_flag() -> bool:
	return transparent

func set_flag(value: bool) -> void:
	transparent = value

func has_transparent_background() -> bool:
	return transparent_bg

func set_transparent_background(value: bool) -> void:
	transparent_bg = value

