extends RefCounted
class_name PacketPeer

## Abstraction and base class for packet-based protocols.
##
## PacketPeer is an abstraction and base class for packet-based protocols (such as UDP). It provides an API for sending and receiving packets both as raw data or variables. This makes it easy to transfer data over a protocol, without having to encode data as low-level bytes or having to worry about network ordering.
## [b]Note:[/b] When exporting to Android, make sure to enable the [code]INTERNET[/code] permission in the Android export preset before exporting the project or using one-click deploy. Otherwise, network communication of any kind will be blocked by Android.



## Maximum buffer size allowed when encoding [Variant]s. Raise this value to support heavier memory allocations.
## The [method put_var] method allocates memory on the stack, and the buffer used will grow automatically to the closest power of two to match the size of the [Variant]. If the [Variant] is bigger than [member encode_buffer_max_size], the method will error out with [constant ERR_OUT_OF_MEMORY].
var encode_buffer_max_size: int:
	get = get_encode_buffer_max_size, set = set_encode_buffer_max_size



## Returns the number of packets currently available in the ring-buffer.
func get_available_packet_count() -> int:
	pass;

## Gets a raw packet.
func get_packet() -> PackedByteArray:
	pass;

## Returns the error state of the last packet received (via [method get_packet] and [method get_var]).
func get_packet_error() -> int:
	pass;

## Gets a Variant. If [param allow_objects] is [code]true[/code], decoding objects is allowed.
## Internally, this uses the same decoding mechanism as the [method @GlobalScope.bytes_to_var] method.
## [b]Warning:[/b] Deserialized objects can contain code which gets executed. Do not use this option if the serialized object comes from untrusted sources to avoid potential security threats such as remote code execution.
func get_var(allow_objects: bool = false) -> Variant:
	pass;

## Sends a raw packet.
func put_packet(buffer: PackedByteArray) -> int:
	pass;

## Sends a [Variant] as a packet. If [param full_objects] is [code]true[/code], encoding objects is allowed (and can potentially include code).
## Internally, this uses the same encoding mechanism as the [method @GlobalScope.var_to_bytes] method.
func put_var(variable: Variant, full_objects: bool = false) -> int:
	pass;


func get_encode_buffer_max_size() -> int:
	return encode_buffer_max_size

func set_encode_buffer_max_size(value: int) -> void:
	encode_buffer_max_size = value

