class_name PackedStringArray

## A packed array of [String]s.
##
## An array specifically designed to hold [String]s. Packs data tightly, so it saves memory for large array sizes.
## If you want to join the strings in the array, use [method String.join].
## [codeblock]
## var string_array = PackedStringArray(["hello", "world"])
## var string = " ".join(string_array)
## print(string) # "hello world"
## [/codeblock]
## [b]Differences between packed arrays, typed arrays, and untyped arrays:[/b] Packed arrays are generally faster to iterate on and modify compared to a typed array of the same type (e.g. [PackedStringArray] versus [code]Array[String][/code]). Also, packed arrays consume less memory. As a downside, packed arrays are less flexible as they don't offer as many convenience methods such as [method Array.map]. Typed arrays are in turn faster to iterate on and modify than untyped arrays.
## [b]Note:[/b] Packed arrays are always passed by reference. To get a copy of an array that can be modified independently of the original array, use [method duplicate]. This is [i]not[/i] the case for built-in properties and methods. The returned packed array of these are a copies, and changing it will [i]not[/i] affect the original value. To update a built-in property you need to modify the returned array, and then assign it to the property again.
##
## @tutorial(Operating System Testing Demo): https://godotengine.org/asset-library/asset/2789




## Constructs an empty [PackedStringArray].
func PackedStringArray() -> PackedStringArray:
	pass;

## Constructs a [PackedStringArray] as a copy of the given [PackedStringArray].
func PackedStringArray(from: PackedStringArray) -> PackedStringArray:
	pass;

## Constructs a new [PackedStringArray]. Optionally, you can pass in a generic [Array] that will be converted.
func PackedStringArray(from: Array) -> PackedStringArray:
	pass;


## Appends an element at the end of the array (alias of [method push_back]).
func append(value: String) -> bool:
	pass;

## Appends a [PackedStringArray] at the end of this array.
func append_array(array: PackedStringArray) -> void:
	pass;

## Finds the index of an existing value (or the insertion index that maintains sorting order, if the value is not yet present in the array) using binary search. Optionally, a [param before] specifier can be passed. If [code]false[/code], the returned index comes after all existing entries of the value in the array.
## [b]Note:[/b] Calling [method bsearch] on an unsorted array results in unexpected behavior.
func bsearch(value: String, before: bool = true) -> int:
	pass;

## Clears the array. This is equivalent to using [method resize] with a size of [code]0[/code].
func clear() -> void:
	pass;

## Returns the number of times an element is in the array.
func count(value: String) -> int:
	pass;

## Creates a copy of the array, and returns it.
func duplicate() -> PackedStringArray:
	pass;

## Assigns the given value to all elements in the array. This can typically be used together with [method resize] to create an array with a given size and initialized elements.
func fill(value: String) -> void:
	pass;

## Searches the array for a value and returns its index or [code]-1[/code] if not found. Optionally, the initial search index can be passed.
func find(value: String, from: int = 0) -> int:
	pass;

## Returns the [String] at the given [param index] in the array. This is the same as using the [code][][/code] operator ([code]array[index][/code]).
func get(index: int) -> String:
	pass;

## Returns [code]true[/code] if the array contains [param value].
func has(value: String) -> bool:
	pass;

## Inserts a new element at a given position in the array. The position must be valid, or at the end of the array ([code]idx == size()[/code]).
func insert(at_index: int, value: String) -> int:
	pass;

## Returns [code]true[/code] if the array is empty.
func is_empty() -> bool:
	pass;

## Appends a string element at end of the array.
func push_back(value: String) -> bool:
	pass;

## Removes an element from the array by index.
func remove_at(index: int) -> void:
	pass;

## Sets the size of the array. If the array is grown, reserves elements at the end of the array. If the array is shrunk, truncates the array to the new size. Calling [method resize] once and assigning the new values is faster than adding new elements one by one.
func resize(new_size: int) -> int:
	pass;

## Reverses the order of the elements in the array.
func reverse() -> void:
	pass;

## Searches the array in reverse order. Optionally, a start search index can be passed. If negative, the start index is considered relative to the end of the array.
func rfind(value: String, from: int = -1) -> int:
	pass;

## Changes the [String] at the given index.
func set(index: int, value: String) -> void:
	pass;

## Returns the number of elements in the array.
func size() -> int:
	pass;

## Returns the slice of the [PackedStringArray], from [param begin] (inclusive) to [param end] (exclusive), as a new [PackedStringArray].
## The absolute value of [param begin] and [param end] will be clamped to the array size, so the default value for [param end] makes it slice to the size of the array by default (i.e. [code]arr.slice(1)[/code] is a shorthand for [code]arr.slice(1, arr.size())[/code]).
## If either [param begin] or [param end] are negative, they will be relative to the end of the array (i.e. [code]arr.slice(0, -2)[/code] is a shorthand for [code]arr.slice(0, arr.size() - 2)[/code]).
func slice(begin: int, end: int = 2147483647) -> PackedStringArray:
	pass;

## Sorts the elements of the array in ascending order.
func sort() -> void:
	pass;

## Returns a [PackedByteArray] with each string encoded as UTF-8. Strings are [code]null[/code] terminated.
func to_byte_array() -> PackedByteArray:
	pass;


