extends OpenXRHapticBase
class_name OpenXRHapticVibration

## Vibration haptic feedback.
##
## This haptic feedback resource makes it possible to define a vibration based haptic feedback pulse that can be triggered through actions in the OpenXR action map.



## The amplitude of the pulse between [code]0.0[/code] and [code]1.0[/code].
var amplitude: float:
	get = get_amplitude, set = set_amplitude

## The duration of the pulse in nanoseconds. Use [code]-1[/code] for a minimum duration pulse for the current XR runtime.
var duration: int:
	get = get_duration, set = set_duration

## The frequency of the pulse in Hz. [code]0.0[/code] will let the XR runtime chose an optimal frequency for the device used.
var frequency: float:
	get = get_frequency, set = set_frequency




func get_amplitude() -> float:
	return amplitude

func set_amplitude(value: float) -> void:
	amplitude = value

func get_duration() -> int:
	return duration

func set_duration(value: int) -> void:
	duration = value

func get_frequency() -> float:
	return frequency

func set_frequency(value: float) -> void:
	frequency = value

