extends OpenXRCompositionLayer
class_name OpenXRCompositionLayerCylinder

## An OpenXR composition layer that is rendered as an internal slice of a cylinder.
##
## An OpenXR composition layer that allows rendering a [SubViewport] on an internal slice of a cylinder.



## The aspect ratio of the slice. Used to set the height relative to the width.
var aspect_ratio: float:
	get = get_aspect_ratio, set = set_aspect_ratio

## The central angle of the cylinder. Used to set the width.
var central_angle: float:
	get = get_central_angle, set = set_central_angle

## The number of segments to use in the fallback mesh.
var fallback_segments: int:
	get = get_fallback_segments, set = set_fallback_segments

## The radius of the cylinder.
var radius: float:
	get = get_radius, set = set_radius




func get_aspect_ratio() -> float:
	return aspect_ratio

func set_aspect_ratio(value: float) -> void:
	aspect_ratio = value

func get_central_angle() -> float:
	return central_angle

func set_central_angle(value: float) -> void:
	central_angle = value

func get_fallback_segments() -> int:
	return fallback_segments

func set_fallback_segments(value: int) -> void:
	fallback_segments = value

func get_radius() -> float:
	return radius

func set_radius(value: float) -> void:
	radius = value

