extends RefCounted
class_name OpenXRAPIExtension

## Makes the OpenXR API available for GDExtension.
##
## [OpenXRAPIExtension] makes OpenXR available for GDExtension. It provides the OpenXR API to GDExtension through the [method get_instance_proc_addr] method, and the OpenXR instance through [method get_instance].
## It also provides methods for querying the status of OpenXR initialization, and helper methods for ease of use of the API with GDExtension.
##
## @tutorial(XrResult documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrResult.html
## @tutorial(XrInstance documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrInstance.html
## @tutorial(XrSpace documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSpace.html
## @tutorial(XrSession documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSession.html
## @tutorial(XrSystemId documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSystemId.html
## @tutorial(xrBeginSession documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/xrBeginSession.html
## @tutorial(XrPosef documentation): https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrPosef.html


## Means that [constant XRInterface.XR_ENV_BLEND_MODE_ALPHA_BLEND] isn't supported at all.
## Means that [constant XRInterface.XR_ENV_BLEND_MODE_ALPHA_BLEND] is really supported.
## Means that [constant XRInterface.XR_ENV_BLEND_MODE_ALPHA_BLEND] is emulated.

#enum OpenXRAlphaBlendModeSupport
enum {
    OPENXR_ALPHA_BLEND_MODE_SUPPORT_NONE = 0,
    OPENXR_ALPHA_BLEND_MODE_SUPPORT_REAL = 1,
    OPENXR_ALPHA_BLEND_MODE_SUPPORT_EMULATING = 2,
}


## Returns the corresponding [code]XrAction[/code] OpenXR handle for the given action RID.
func action_get_handle(action: RID) -> int:
	pass;

## Begins a new debug label region, this label will be reported in debug messages for any calls following this until [method end_debug_label_region] is called. Debug labels can be stacked.
func begin_debug_label_region(label_name: String) -> void:
	pass;

## Returns [code]true[/code] if OpenXR is initialized for rendering with an XR viewport.
func can_render() -> bool:
	pass;

## Marks the end of a debug label region. Removes the latest debug label region added by calling [method begin_debug_label_region].
func end_debug_label_region() -> void:
	pass;

## Returns the [RID] corresponding to an [code]Action[/code] of a matching name, optionally limited to a specified action set.
func find_action(name: String, action_set: RID) -> RID:
	pass;

## Returns an error string for the given [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrResult.html]XrResult[/url].
func get_error_string(result: int) -> String:
	pass;

## Returns the corresponding [code]XRHandTrackerEXT[/code] handle for the given hand index value.
func get_hand_tracker(hand_index: int) -> int:
	pass;

## Returns the [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrInstance.html]XrInstance[/url] created during the initialization of the OpenXR API.
func get_instance() -> int:
	pass;

## Returns the function pointer of the OpenXR function with the specified name, cast to an integer. If the function with the given name does not exist, the method returns [code]0[/code].
## [b]Note:[/b] [code]openxr/util.h[/code] contains utility macros for acquiring OpenXR functions, e.g. [code]GDEXTENSION_INIT_XR_FUNC_V(xrCreateAction)[/code].
func get_instance_proc_addr(name: String) -> int:
	pass;

## Returns the predicted display timing for the next frame.
func get_next_frame_time() -> int:
	pass;

## Returns the play space, which is an [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSpace.html]XrSpace[/url] cast to an integer.
func get_play_space() -> int:
	pass;

## Returns the predicted display timing for the current frame.
func get_predicted_display_time() -> int:
	pass;

## Returns a pointer to the render state's [code]XrCompositionLayerProjection[/code] struct.
## [b]Note:[/b] This method should only be called from the rendering thread.
func get_projection_layer() -> int:
	pass;

## Returns the far boundary value of the camera frustum.
## [b]Note:[/b] This is only accessible in the render thread.
func get_render_state_z_far() -> float:
	pass;

## Returns the near boundary value of the camera frustum.
## [b]Note:[/b] This is only accessible in the render thread.
func get_render_state_z_near() -> float:
	pass;

## Returns the OpenXR session, which is an [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSession.html]XrSession[/url] cast to an integer.
func get_session() -> int:
	pass;

## Returns an array of supported swapchain formats.
func get_supported_swapchain_formats() -> PackedInt64Array:
	pass;

## Returns the name of the specified swapchain format.
func get_swapchain_format_name(swapchain_format: int) -> String:
	pass;

## Returns the id of the system, which is a [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrSystemId.html]XrSystemId[/url] cast to an integer.
func get_system_id() -> int:
	pass;

## Inserts a debug label, this label is reported in any debug message resulting from the OpenXR calls that follows, until any of [method begin_debug_label_region], [method end_debug_label_region], or [method insert_debug_label] is called.
func insert_debug_label(label_name: String) -> void:
	pass;

## Returns [enum OpenXRAPIExtension.OpenXRAlphaBlendModeSupport] denoting if [constant XRInterface.XR_ENV_BLEND_MODE_ALPHA_BLEND] is really supported, emulated or not supported at all.
func is_environment_blend_mode_alpha_supported() -> int:
	pass;

## Returns [code]true[/code] if OpenXR is initialized.
func is_initialized() -> bool:
	pass;

## Returns [code]true[/code] if OpenXR is running ([url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/xrBeginSession.html]xrBeginSession[/url] was successfully called and the swapchains were created).
func is_running() -> bool:
	pass;

## Returns [code]true[/code] if OpenXR is enabled.
static func openxr_is_enabled(check_run_in_editor: bool) -> bool:
	pass;

## Acquires the image of the provided swapchain.
func openxr_swapchain_acquire(swapchain: int) -> void:
	pass;

## Returns a pointer to a new swapchain created using the provided parameters.
func openxr_swapchain_create(create_flags: int, usage_flags: int, swapchain_format: int, width: int, height: int, sample_count: int, array_size: int) -> int:
	pass;

## Destroys the provided swapchain and frees it from memory.
func openxr_swapchain_free(swapchain: int) -> void:
	pass;

## Returns the RID of the provided swapchain's image.
func openxr_swapchain_get_image(swapchain: int) -> RID:
	pass;

## Returns the [code]XrSwapchain[/code] handle of the provided swapchain.
func openxr_swapchain_get_swapchain(swapchain: int) -> int:
	pass;

## Releases the image of the provided swapchain.
func openxr_swapchain_release(swapchain: int) -> void:
	pass;

## Registers the given extension as a composition layer provider.
func register_composition_layer_provider(extension: OpenXRExtensionWrapperExtension) -> void:
	pass;

## Registers the given extension as a provider of additional data structures to projections views.
func register_projection_views_extension(extension: OpenXRExtensionWrapperExtension) -> void:
	pass;

## If set to [code]true[/code], an OpenXR extension is loaded which is capable of emulating the [constant XRInterface.XR_ENV_BLEND_MODE_ALPHA_BLEND] blend mode.
func set_emulate_environment_blend_mode_alpha_blend(enabled: bool) -> void:
	pass;

## Set the object name of an OpenXR object, used for debug output. [param object_type] must be a valid OpenXR [code]XrObjectType[/code] enum and [param object_handle] must be a valid OpenXR object handle.
func set_object_name(object_type: int, object_handle: int, object_name: String) -> void:
	pass;

## Sets the render region to [param render_region], overriding the normal render target's rect.
func set_render_region(render_region: Rect2i) -> void:
	pass;

## Sets the render target of the velocity depth texture.
func set_velocity_depth_texture(render_target: RID) -> void:
	pass;

## Sets the target size of the velocity and velocity depth textures.
func set_velocity_target_size(target_size: Vector2i) -> void:
	pass;

## Sets the render target of the velocity texture.
func set_velocity_texture(render_target: RID) -> void:
	pass;

## Creates a [Transform3D] from an [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrPosef.html]XrPosef[/url].
func transform_from_pose(pose: const void*) -> Transform3D:
	pass;

## Unregisters the given extension as a composition layer provider.
func unregister_composition_layer_provider(extension: OpenXRExtensionWrapperExtension) -> void:
	pass;

## Unregisters the given extension as a provider of additional data structures to projections views.
func unregister_projection_views_extension(extension: OpenXRExtensionWrapperExtension) -> void:
	pass;

## Returns [code]true[/code] if the provided [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrResult.html]XrResult[/url] (cast to an integer) is successful. Otherwise returns [code]false[/code] and prints the [url=https://registry.khronos.org/OpenXR/specs/1.0/man/html/XrResult.html]XrResult[/url] converted to a string, with the specified additional information.
func xr_result(result: int, format: String, args: Array) -> bool:
	pass;


