extends Resource
class_name NavigationMeshSourceGeometryData3D

## Container for parsed source geometry data used in navigation mesh baking.
##
## Container for parsed source geometry data used in navigation mesh baking.





## Adds an array of vertex positions to the geometry data for navigation mesh baking to form triangulated faces. For each face the array must have three vertex positions in clockwise winding order. Since [NavigationMesh] resources have no transform, all vertex positions need to be offset by the node's transform using [param xform].
func add_faces(faces: PackedVector3Array, xform: Transform3D) -> void:
	pass;

## Adds the geometry data of a [Mesh] resource to the navigation mesh baking data. The mesh must have valid triangulated mesh data to be considered. Since [NavigationMesh] resources have no transform, all vertex positions need to be offset by the node's transform using [param xform].
func add_mesh(mesh: Mesh, xform: Transform3D) -> void:
	pass;

## Adds an [Array] the size of [constant Mesh.ARRAY_MAX] and with vertices at index [constant Mesh.ARRAY_VERTEX] and indices at index [constant Mesh.ARRAY_INDEX] to the navigation mesh baking data. The array must have valid triangulated mesh data to be considered. Since [NavigationMesh] resources have no transform, all vertex positions need to be offset by the node's transform using [param xform].
func add_mesh_array(mesh_array: Array, xform: Transform3D) -> void:
	pass;

## Adds a projected obstruction shape to the source geometry. The [param vertices] are considered projected on a xz-axes plane, placed at the global y-axis [param elevation] and extruded by [param height]. If [param carve] is [code]true[/code] the carved shape will not be affected by additional offsets (e.g. agent radius) of the navigation mesh baking process.
func add_projected_obstruction(vertices: PackedVector3Array, elevation: float, height: float, carve: bool) -> void:
	pass;

## Appends arrays of [param vertices] and [param indices] at the end of the existing arrays. Adds the existing index as an offset to the appended indices.
func append_arrays(vertices: PackedFloat32Array, indices: PackedInt32Array) -> void:
	pass;

## Clears the internal data.
func clear() -> void:
	pass;

## Clears all projected obstructions.
func clear_projected_obstructions() -> void:
	pass;

## Returns an axis-aligned bounding box that covers all the stored geometry data. The bounds are calculated when calling this function with the result cached until further geometry changes are made.
func get_bounds() -> AABB:
	pass;

## Returns the parsed source geometry data indices array.
func get_indices() -> PackedInt32Array:
	pass;

## Returns the projected obstructions as an [Array] of dictionaries. Each [Dictionary] contains the following entries:
## - [code]vertices[/code] - A [PackedFloat32Array] that defines the outline points of the projected shape.
## - [code]elevation[/code] - A [float] that defines the projected shape placement on the y-axis.
## - [code]height[/code] - A [float] that defines how much the projected shape is extruded along the y-axis.
## - [code]carve[/code] - A [bool] that defines how the obstacle affects the navigation mesh baking. If [code]true[/code] the projected shape will not be affected by addition offsets, e.g. agent radius.
func get_projected_obstructions() -> Array:
	pass;

## Returns the parsed source geometry data vertices array.
func get_vertices() -> PackedFloat32Array:
	pass;

## Returns [code]true[/code] when parsed source geometry data exists.
func has_data() -> bool:
	pass;

## Adds the geometry data of another [NavigationMeshSourceGeometryData3D] to the navigation mesh baking data.
func merge(other_geometry: NavigationMeshSourceGeometryData3D) -> void:
	pass;

## Sets the parsed source geometry data indices. The indices need to be matched with appropriated vertices.
## [b]Warning:[/b] Inappropriate data can crash the baking process of the involved third-party libraries.
func set_indices(indices: PackedInt32Array) -> void:
	pass;

## Sets the projected obstructions with an Array of Dictionaries with the following key value pairs:
## [codeblocks]
## [gdscript]
## "vertices" : PackedFloat32Array
## "elevation" : float
## "height" : float
## "carve" : bool
## [/gdscript]
## [/codeblocks]
func set_projected_obstructions(projected_obstructions: Array) -> void:
	pass;

## Sets the parsed source geometry data vertices. The vertices need to be matched with appropriated indices.
## [b]Warning:[/b] Inappropriate data can crash the baking process of the involved third-party libraries.
func set_vertices(vertices: PackedFloat32Array) -> void:
	pass;


