extends SkeletonModifier3D
class_name LookAtModifier3D

## The [LookAtModifier3D] rotates a bone to look at a target.
##
## This [SkeletonModifier3D] rotates a bone to look at a target. This is helpful for moving a character's head to look at the player, rotating a turret to look at a target, or any other case where you want to make a bone rotate towards something quickly and easily.
## When applying multiple [LookAtModifier3D]s, the [LookAtModifier3D] assigned to the parent bone must be put above the [LookAtModifier3D] assigned to the child bone in the list in order for the child bone results to be correct.


## The bone rest position of the bone specified in [member bone] is used as origin.
## The bone global pose position of the bone specified in [member origin_bone] is used as origin.
## [b]Note:[/b] It is recommended that you select only the parent bone unless you are familiar with the bone processing process. The specified bone pose at the time the [LookAtModifier3D] is processed is used as a reference. In other words, if you specify a child bone and the [LookAtModifier3D] causes the child bone to move, the rendered result and direction will not match.
## The global position of the [Node3D] specified in [member origin_external_node] is used as origin.
## [b]Note:[/b] Same as [constant ORIGIN_FROM_SPECIFIC_BONE], when specifying a [BoneAttachment3D] with a child bone assigned, the rendered result and direction will not match.

#enum OriginFrom
enum {
    ORIGIN_FROM_SELF = 0,
    ORIGIN_FROM_SPECIFIC_BONE = 1,
    ORIGIN_FROM_EXTERNAL_NODE = 2,
}
## Index of the [member bone_name] in the parent [Skeleton3D].
var bone: int:
	get = get_bone, set = set_bone

## The bone name of the [Skeleton3D] that the modification will operate on.
var bone_name: String:
	get = get_bone_name, set = set_bone_name

## The duration of the time-based interpolation. Interpolation is triggered at the following cases:
## - When the target node is changed
## - When an axis is flipped due to angle limitation
## [b]Note:[/b] The flipping occurs when the target is outside the angle limitation and the internally computed secondary rotation axis of the forward vector is flipped. Visually, it occurs when the target is outside the angle limitation and crosses the plane of the [member forward_axis] and [member primary_rotation_axis].
var duration: float:
	get = get_duration, set = set_duration

## The ease type of the time-based interpolation. See also [enum Tween.EaseType].
var ease_type: int:
	get = get_ease_type, set = set_ease_type

## The forward axis of the bone. This [SkeletonModifier3D] modifies the bone so that this axis points toward the [member target_node].
var forward_axis: int:
	get = get_forward_axis, set = set_forward_axis

## Index of the [member origin_bone_name] in the parent [Skeleton3D].
var origin_bone: int:
	get = get_origin_bone, set = set_origin_bone

## If [member origin_from] is [constant ORIGIN_FROM_SPECIFIC_BONE], the bone global pose position specified for this is used as origin.
var origin_bone_name: String:
	get = get_origin_bone_name, set = set_origin_bone_name

## If [member origin_from] is [constant ORIGIN_FROM_EXTERNAL_NODE], the global position of the [Node3D] specified for this is used as origin.
var origin_external_node: NodePath:
	get = get_origin_external_node, set = set_origin_external_node

## This value determines from what origin is retrieved for use in the calculation of the forward vector.
var origin_from: int:
	get = get_origin_from, set = set_origin_from

## The offset of the bone pose origin. Matching the origins by offset is useful for cases where multiple bones must always face the same direction, such as the eyes.
## [b]Note:[/b] This value indicates the local position of the object set in [member origin_from].
var origin_offset: Vector3:
	get = get_origin_offset, set = set_origin_offset

## If the target passes through too close to the origin than this value, time-based interpolation is used even if the target is within the angular limitations, to prevent the angular velocity from becoming too high.
var origin_safe_margin: float:
	get = get_origin_safe_margin, set = set_origin_safe_margin

## The threshold to start damping for [member primary_limit_angle]. It provides non-linear (b-spline) interpolation, let it feel more resistance the more it rotate to the edge limit. This is useful for simulating the limits of human motion.
## If [code]1.0[/code], no damping is performed. If [code]0.0[/code], damping is always performed.
var primary_damp_threshold: float:
	get = get_primary_damp_threshold, set = set_primary_damp_threshold

## The limit angle of the primary rotation when [member symmetry_limitation] is [code]true[/code].
var primary_limit_angle: float:
	get = get_primary_limit_angle, set = set_primary_limit_angle

## The threshold to start damping for [member primary_negative_limit_angle].
var primary_negative_damp_threshold: float:
	get = get_primary_negative_damp_threshold, set = set_primary_negative_damp_threshold

## The limit angle of negative side of the primary rotation when [member symmetry_limitation] is [code]false[/code].
var primary_negative_limit_angle: float:
	get = get_primary_negative_limit_angle, set = set_primary_negative_limit_angle

## The threshold to start damping for [member primary_positive_limit_angle].
var primary_positive_damp_threshold: float:
	get = get_primary_positive_damp_threshold, set = set_primary_positive_damp_threshold

## The limit angle of positive side of the primary rotation when [member symmetry_limitation] is [code]false[/code].
var primary_positive_limit_angle: float:
	get = get_primary_positive_limit_angle, set = set_primary_positive_limit_angle

## The axis of the first rotation. This [SkeletonModifier3D] works by compositing the rotation by Euler angles to prevent to rotate the [member forward_axis].
var primary_rotation_axis: int:
	get = get_primary_rotation_axis, set = set_primary_rotation_axis

## The threshold to start damping for [member secondary_limit_angle].
var secondary_damp_threshold: float:
	get = get_secondary_damp_threshold, set = set_secondary_damp_threshold

## The limit angle of the secondary rotation when [member symmetry_limitation] is [code]true[/code].
var secondary_limit_angle: float:
	get = get_secondary_limit_angle, set = set_secondary_limit_angle

## The threshold to start damping for [member secondary_negative_limit_angle].
var secondary_negative_damp_threshold: float:
	get = get_secondary_negative_damp_threshold, set = set_secondary_negative_damp_threshold

## The limit angle of negative side of the secondary rotation when [member symmetry_limitation] is [code]false[/code].
var secondary_negative_limit_angle: float:
	get = get_secondary_negative_limit_angle, set = set_secondary_negative_limit_angle

## The threshold to start damping for [member secondary_positive_limit_angle].
var secondary_positive_damp_threshold: float:
	get = get_secondary_positive_damp_threshold, set = set_secondary_positive_damp_threshold

## The limit angle of positive side of the secondary rotation when [member symmetry_limitation] is [code]false[/code].
var secondary_positive_limit_angle: float:
	get = get_secondary_positive_limit_angle, set = set_secondary_positive_limit_angle

## If [code]true[/code], the limitations are spread from the bone symmetrically.
## If [code]false[/code], the limitation can be specified separately for each side of the bone rest.
var symmetry_limitation: bool:
	get = is_limitation_symmetry, set = set_symmetry_limitation

## The [NodePath] to the node that is the target for the look at modification. This node is what the modification will rotate the bone to.
var target_node: NodePath:
	get = get_target_node, set = set_target_node

## The transition type of the time-based interpolation. See also [enum Tween.TransitionType].
var transition_type: int:
	get = get_transition_type, set = set_transition_type

## If [code]true[/code], limits the degree of rotation. This helps prevent the character's neck from rotating 360 degrees.
## [b]Note:[/b] As with [AnimationTree] blending, interpolation is provided that favors [method Skeleton3D.get_bone_rest]. This means that interpolation does not select the shortest path in some cases.
## [b]Note:[/b] Some [member transition_type] may exceed the limitations (e.g. `Back`, `Elastic`, and `Spring`). If interpolation occurs while overshooting the limitations, the result might possibly not respect the bone rest.
var use_angle_limitation: bool:
	get = is_using_angle_limitation, set = set_use_angle_limitation

## If [code]true[/code], provides rotation by two axes.
var use_secondary_rotation: bool:
	get = is_using_secondary_rotation, set = set_use_secondary_rotation



## Returns the remaining seconds of the time-based interpolation.
func get_interpolation_remaining() -> float:
	pass;

## Returns whether the time-based interpolation is running or not. If [code]true[/code], it is equivalent to [method get_interpolation_remaining] being [code]0[/code].
## This is useful to determine whether a [LookAtModifier3D] can be removed safely.
func is_interpolating() -> bool:
	pass;

## Returns whether the target is within the angle limitations. It is useful for unsetting the [member target_node] when the target is outside of the angle limitations.
## [b]Note:[/b] The value is updated after [method SkeletonModifier3D._process_modification]. To retrieve this value correctly, we recommend using the signal [signal SkeletonModifier3D.modification_processed].
func is_target_within_limitation() -> bool:
	pass;


func get_bone() -> int:
	return bone

func set_bone(value: int) -> void:
	bone = value

func get_bone_name() -> String:
	return bone_name

func set_bone_name(value: String) -> void:
	bone_name = value

func get_duration() -> float:
	return duration

func set_duration(value: float) -> void:
	duration = value

func get_ease_type() -> int:
	return ease_type

func set_ease_type(value: int) -> void:
	ease_type = value

func get_forward_axis() -> int:
	return forward_axis

func set_forward_axis(value: int) -> void:
	forward_axis = value

func get_origin_bone() -> int:
	return origin_bone

func set_origin_bone(value: int) -> void:
	origin_bone = value

func get_origin_bone_name() -> String:
	return origin_bone_name

func set_origin_bone_name(value: String) -> void:
	origin_bone_name = value

func get_origin_external_node() -> NodePath:
	return origin_external_node

func set_origin_external_node(value: NodePath) -> void:
	origin_external_node = value

func get_origin_from() -> int:
	return origin_from

func set_origin_from(value: int) -> void:
	origin_from = value

func get_origin_offset() -> Vector3:
	return origin_offset

func set_origin_offset(value: Vector3) -> void:
	origin_offset = value

func get_origin_safe_margin() -> float:
	return origin_safe_margin

func set_origin_safe_margin(value: float) -> void:
	origin_safe_margin = value

func get_primary_damp_threshold() -> float:
	return primary_damp_threshold

func set_primary_damp_threshold(value: float) -> void:
	primary_damp_threshold = value

func get_primary_limit_angle() -> float:
	return primary_limit_angle

func set_primary_limit_angle(value: float) -> void:
	primary_limit_angle = value

func get_primary_negative_damp_threshold() -> float:
	return primary_negative_damp_threshold

func set_primary_negative_damp_threshold(value: float) -> void:
	primary_negative_damp_threshold = value

func get_primary_negative_limit_angle() -> float:
	return primary_negative_limit_angle

func set_primary_negative_limit_angle(value: float) -> void:
	primary_negative_limit_angle = value

func get_primary_positive_damp_threshold() -> float:
	return primary_positive_damp_threshold

func set_primary_positive_damp_threshold(value: float) -> void:
	primary_positive_damp_threshold = value

func get_primary_positive_limit_angle() -> float:
	return primary_positive_limit_angle

func set_primary_positive_limit_angle(value: float) -> void:
	primary_positive_limit_angle = value

func get_primary_rotation_axis() -> int:
	return primary_rotation_axis

func set_primary_rotation_axis(value: int) -> void:
	primary_rotation_axis = value

func get_secondary_damp_threshold() -> float:
	return secondary_damp_threshold

func set_secondary_damp_threshold(value: float) -> void:
	secondary_damp_threshold = value

func get_secondary_limit_angle() -> float:
	return secondary_limit_angle

func set_secondary_limit_angle(value: float) -> void:
	secondary_limit_angle = value

func get_secondary_negative_damp_threshold() -> float:
	return secondary_negative_damp_threshold

func set_secondary_negative_damp_threshold(value: float) -> void:
	secondary_negative_damp_threshold = value

func get_secondary_negative_limit_angle() -> float:
	return secondary_negative_limit_angle

func set_secondary_negative_limit_angle(value: float) -> void:
	secondary_negative_limit_angle = value

func get_secondary_positive_damp_threshold() -> float:
	return secondary_positive_damp_threshold

func set_secondary_positive_damp_threshold(value: float) -> void:
	secondary_positive_damp_threshold = value

func get_secondary_positive_limit_angle() -> float:
	return secondary_positive_limit_angle

func set_secondary_positive_limit_angle(value: float) -> void:
	secondary_positive_limit_angle = value

func is_limitation_symmetry() -> bool:
	return symmetry_limitation

func set_symmetry_limitation(value: bool) -> void:
	symmetry_limitation = value

func get_target_node() -> NodePath:
	return target_node

func set_target_node(value: NodePath) -> void:
	target_node = value

func get_transition_type() -> int:
	return transition_type

func set_transition_type(value: int) -> void:
	transition_type = value

func is_using_angle_limitation() -> bool:
	return use_angle_limitation

func set_use_angle_limitation(value: bool) -> void:
	use_angle_limitation = value

func is_using_secondary_rotation() -> bool:
	return use_secondary_rotation

func set_use_secondary_rotation(value: bool) -> void:
	use_secondary_rotation = value

