extends Object
class_name JavaClassWrapper

## Provides access to the Java Native Interface.
##
## The JavaClassWrapper singleton provides a way for the Godot application to send and receive data through the [url=https://developer.android.com/training/articles/perf-jni]Java Native Interface[/url] (JNI).
## [b]Note:[/b] This singleton is only available in Android builds.
## [codeblock]
## var LocalDateTime = JavaClassWrapper.wrap("java.time.LocalDateTime")
## var DateTimeFormatter = JavaClassWrapper.wrap("java.time.format.DateTimeFormatter")
## var datetime = LocalDateTime.now()
## var formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss")
## print(datetime.format(formatter))
## [/codeblock]
## [b]Warning:[/b] When calling Java methods, be sure to check [method JavaClassWrapper.get_exception] to check if the method threw an exception.





## Returns the Java exception from the last call into a Java class. If there was no exception, it will return [code]null[/code].
## [b]Note:[/b] This method only works on Android. On every other platform, this method will always return [code]null[/code].
func get_exception() -> JavaObject:
	pass;

## Wraps a class defined in Java, and returns it as a [JavaClass] [Object] type that Godot can interact with.
## When wrapping inner (nested) classes, use [code]$[/code] instead of [code].[/code] to separate them. For example, [code]JavaClassWrapper.wrap("android.view.WindowManager$LayoutParams")[/code] wraps the [b]WindowManager.LayoutParams[/b] class.
## [b]Note:[/b] This method only works on Android. On every other platform, this method does nothing and returns an empty [JavaClass].
func wrap(name: String) -> JavaClass:
	pass;


