extends Joint2D
class_name GrooveJoint2D

## A physics joint that restricts the movement of two 2D physics bodies to a fixed axis.
##
## A physics joint that restricts the movement of two 2D physics bodies to a fixed axis. For example, a [StaticBody2D] representing a piston base can be attached to a [RigidBody2D] representing the piston head, moving up and down.



## The body B's initial anchor position defined by the joint's origin and a local offset [member initial_offset] along the joint's Y axis (along the groove).
var initial_offset: float:
	get = get_initial_offset, set = set_initial_offset

## The groove's length. The groove is from the joint's origin towards [member length] along the joint's local Y axis.
var length: float:
	get = get_length, set = set_length




func get_initial_offset() -> float:
	return initial_offset

func set_initial_offset(value: float) -> void:
	initial_offset = value

func get_length() -> float:
	return length

func set_length(value: float) -> void:
	length = value

