extends EditorPlugin
class_name GridMapEditorPlugin

## Editor for [GridMap] nodes.
##
## GridMapEditorPlugin provides access to the [GridMap] editor functionality.





## Deselects any currently selected cells.
func clear_selection() -> void:
	pass;

## Returns the [GridMap] node currently edited by the grid map editor.
func get_current_grid_map() -> GridMap:
	pass;

## Returns an array of [Vector3i]s with the selected cells' coordinates.
func get_selected_cells() -> Array:
	pass;

## Returns the index of the selected [MeshLibrary] item in the grid map editor's palette or [code]-1[/code] if no item is selected.
## [b]Note:[/b] The indices might not be in the same order as they appear in the editor's interface.
func get_selected_palette_item() -> int:
	pass;

## Returns the cell coordinate bounds of the current selection. Use [method has_selection] to check if there is an active selection.
func get_selection() -> AABB:
	pass;

## Returns [code]true[/code] if there are selected cells.
func has_selection() -> bool:
	pass;

## Selects the [MeshLibrary] item with the given index in the grid map editor's palette. If a negative index is given, no item will be selected. If a value greater than the last index is given, the last item will be selected.
## [b]Note:[/b] The indices might not be in the same order as they appear in the editor's interface.
func set_selected_palette_item(item: int) -> void:
	pass;

## Selects the cells inside the given bounds from [param begin] to [param end].
func set_selection(begin: Vector3i, end: Vector3i) -> void:
	pass;


