extends Resource
class_name GLTFTexture

## GLTFTexture represents a texture in a glTF file.
##
## @tutorial(Runtime file loading and saving): https://docs.godotengine.org/en/stable/tutorials/io/runtime_file_loading_and_saving.html



## ID of the texture sampler to use when sampling the image. If -1, then the default texture sampler is used (linear filtering, and repeat wrapping in both axes).
var sampler: int:
	get = get_sampler, set = set_sampler

## The index of the image associated with this texture, see [method GLTFState.get_images]. If -1, then this texture does not have an image assigned.
var src_image: int:
	get = get_src_image, set = set_src_image




func get_sampler() -> int:
	return sampler

func set_sampler(value: int) -> void:
	sampler = value

func get_src_image() -> int:
	return src_image

func set_src_image(value: int) -> void:
	src_image = value

