extends Object
class_name EngineDebugger

## Exposes the internal debugger.
##
## [EngineDebugger] handles the communication between the editor and the running game. It is active in the running game. Messages can be sent/received through it. It also manages the profilers.





## Clears all breakpoints.
func clear_breakpoints() -> void:
	pass;

## Starts a debug break in script execution, optionally specifying whether the program can continue based on [param can_continue] and whether the break was due to a breakpoint.
func debug(can_continue: bool = true, is_error_breakpoint: bool = false) -> void:
	pass;

## Returns the current debug depth.
func get_depth() -> int:
	pass;

## Returns the number of lines that remain.
func get_lines_left() -> int:
	pass;

## Returns [code]true[/code] if a capture with the given name is present otherwise [code]false[/code].
func has_capture(name: StringName) -> bool:
	pass;

## Returns [code]true[/code] if a profiler with the given name is present otherwise [code]false[/code].
func has_profiler(name: StringName) -> bool:
	pass;

## Inserts a new breakpoint with the given [param source] and [param line].
func insert_breakpoint(line: int, source: StringName) -> void:
	pass;

## Returns [code]true[/code] if the debugger is active otherwise [code]false[/code].
func is_active() -> bool:
	pass;

## Returns [code]true[/code] if the given [param source] and [param line] represent an existing breakpoint.
func is_breakpoint(line: int, source: StringName) -> bool:
	pass;

## Returns [code]true[/code] if a profiler with the given name is present and active otherwise [code]false[/code].
func is_profiling(name: StringName) -> bool:
	pass;

## Returns [code]true[/code] if the debugger is skipping breakpoints otherwise [code]false[/code].
func is_skipping_breakpoints() -> bool:
	pass;

## Forces a processing loop of debugger events. The purpose of this method is just processing events every now and then when the script might get too busy, so that bugs like infinite loops can be caught.
func line_poll() -> void:
	pass;

## Calls the [code]add[/code] callable of the profiler with given [param name] and [param data].
func profiler_add_frame_data(name: StringName, data: Array) -> void:
	pass;

## Calls the [code]toggle[/code] callable of the profiler with given [param name] and [param arguments]. Enables/Disables the same profiler depending on [param enable] argument.
func profiler_enable(name: StringName, enable: bool, arguments: Array = []) -> void:
	pass;

## Registers a message capture with given [param name]. If [param name] is "my_message" then messages starting with "my_message:" will be called with the given callable.
## The callable must accept a message string and a data array as argument. The callable should return [code]true[/code] if the message is recognized.
## [b]Note:[/b] The callable will receive the message with the prefix stripped, unlike [method EditorDebuggerPlugin._capture]. See the [EditorDebuggerPlugin] description for an example.
func register_message_capture(name: StringName, callable: Callable) -> void:
	pass;

## Registers a profiler with the given [param name]. See [EngineProfiler] for more information.
func register_profiler(name: StringName, profiler: EngineProfiler) -> void:
	pass;

## Removes a breakpoint with the given [param source] and [param line].
func remove_breakpoint(line: int, source: StringName) -> void:
	pass;

## Starts a debug break in script execution, optionally specifying whether the program can continue based on [param can_continue] and whether the break was due to a breakpoint.
func script_debug(language: ScriptLanguage, can_continue: bool = true, is_error_breakpoint: bool = false) -> void:
	pass;

## Sends a message with given [param message] and [param data] array.
func send_message(message: String, data: Array) -> void:
	pass;

## Sets the current debugging depth.
func set_depth(depth: int) -> void:
	pass;

## Sets the current debugging lines that remain.
func set_lines_left(lines: int) -> void:
	pass;

## Unregisters the message capture with given [param name].
func unregister_message_capture(name: StringName) -> void:
	pass;

## Unregisters a profiler with given [param name].
func unregister_profiler(name: StringName) -> void:
	pass;


