extends SyntaxHighlighter
class_name EditorSyntaxHighlighter

## Base class for [SyntaxHighlighter] used by the [ScriptEditor].
##
## Base class that all [SyntaxHighlighter]s used by the [ScriptEditor] extend from.
## Add a syntax highlighter to an individual script by calling [method ScriptEditorBase.add_syntax_highlighter]. To apply to all scripts on open, call [method ScriptEditor.register_syntax_highlighter].





## Virtual method which can be overridden to return the syntax highlighter name.
func _get_name() -> String:
	pass;

## Virtual method which can be overridden to return the supported language names.
func _get_supported_languages() -> PackedStringArray:
	pass;


