extends RefCounted
class_name EditorSceneFormatImporter

## Imports scenes from third-parties' 3D files.
##
## [EditorSceneFormatImporter] allows to define an importer script for a third-party 3D format.
## To use [EditorSceneFormatImporter], register it using the [method EditorPlugin.add_scene_format_importer_plugin] method first.


const IMPORT_SCENE = 1;

const IMPORT_ANIMATION = 2;

const IMPORT_FAIL_ON_MISSING_DEPENDENCIES = 4;

const IMPORT_GENERATE_TANGENT_ARRAYS = 8;

const IMPORT_USE_NAMED_SKIN_BINDS = 16;

const IMPORT_DISCARD_MESHES_AND_MATERIALS = 32;

const IMPORT_FORCE_DISABLE_MESH_COMPRESSION = 64;




## Return supported file extensions for this scene importer.
func _get_extensions() -> PackedStringArray:
	pass;

## Override to add general import options. These will appear in the main import dock on the editor. Add options via [method add_import_option] and [method add_import_option_advanced].
## [b]Note:[/b] All [EditorSceneFormatImporter] and [EditorScenePostImportPlugin] instances will add options for all files. It is good practice to check the file extension when [param path] is non-empty.
## When the user is editing project settings, [param path] will be empty. It is recommended to add all options when [param path] is empty to allow the user to customize Import Defaults.
func _get_import_options(path: String) -> void:
	pass;

## Should return [code]true[/code] to show the given option, [code]false[/code] to hide the given option, or [code]null[/code] to ignore.
func _get_option_visibility(path: String, for_animation: bool, option: String) -> Variant:
	pass;

## Perform the bulk of the scene import logic here, for example using [GLTFDocument] or [FBXDocument].
func _import_scene(path: String, flags: int, options: Dictionary) -> Object:
	pass;

## Add a specific import option (name and default value only). This function can only be called from [method _get_import_options].
func add_import_option(name: String, value: Variant) -> void:
	pass;

## Add a specific import option. This function can only be called from [method _get_import_options].
func add_import_option_advanced(type: int, name: String, default_value: Variant, hint: int = 0, hint_string: String = "", usage_flags: int = 6) -> void:
	pass;


