extends Node3D
class_name CollisionPolygon3D

## A node that provides a thickened polygon shape (a prism) to a [CollisionObject3D] parent.
##
## A node that provides a thickened polygon shape (a prism) to a [CollisionObject3D] parent and allows to edit it. The polygon can be concave or convex. This can give a detection shape to an [Area3D] or turn [PhysicsBody3D] into a solid object.
## [b]Warning:[/b] A non-uniformly scaled [CollisionShape3D] will likely not behave as expected. Make sure to keep its scale the same on all axes and adjust its shape resource instead.



## The collision shape color that is displayed in the editor, or in the running project if [b]Debug > Visible Collision Shapes[/b] is checked at the top of the editor.
## [b]Note:[/b] The default value is [member ProjectSettings.debug/shapes/collision/shape_color]. The [code]Color(0, 0, 0, 0)[/code] value documented here is a placeholder, and not the actual default debug color.
var debug_color: Color:
	get = get_debug_color, set = set_debug_color

## If [code]true[/code], when the shape is displayed, it will show a solid fill color in addition to its wireframe.
var debug_fill: bool:
	get = get_enable_debug_fill, set = set_enable_debug_fill

## Length that the resulting collision extends in either direction perpendicular to its 2D polygon.
var depth: float:
	get = get_depth, set = set_depth

## If [code]true[/code], no collision will be produced.
var disabled: bool:
	get = is_disabled, set = set_disabled

## The collision margin for the generated [Shape3D]. See [member Shape3D.margin] for more details.
var margin: float:
	get = get_margin, set = set_margin

## Array of vertices which define the 2D polygon in the local XY plane.
var polygon: PackedVector2Array:
	get = get_polygon, set = set_polygon




func get_debug_color() -> Color:
	return debug_color

func set_debug_color(value: Color) -> void:
	debug_color = value

func get_enable_debug_fill() -> bool:
	return debug_fill

func set_enable_debug_fill(value: bool) -> void:
	debug_fill = value

func get_depth() -> float:
	return depth

func set_depth(value: float) -> void:
	depth = value

func is_disabled() -> bool:
	return disabled

func set_disabled(value: bool) -> void:
	disabled = value

func get_margin() -> float:
	return margin

func set_margin(value: float) -> void:
	margin = value

func get_polygon() -> PackedVector2Array:
	return polygon

func set_polygon(value: PackedVector2Array) -> void:
	polygon = value

