extends AudioEffect
class_name AudioEffectStereoEnhance

## An audio effect that can be used to adjust the intensity of stereo panning.
##
## An audio effect that can be used to adjust the intensity of stereo panning.
##
## @tutorial(Audio buses): https://docs.godotengine.org/en/stable/tutorials/audio/audio_buses.html



## Amplifies the difference between stereo channels, increasing or decreasing existing panning. A value of 0.0 will downmix stereo to mono. Does not affect a mono signal.
var pan_pullout: float:
	get = get_pan_pullout, set = set_pan_pullout

## Widens sound stage through phase shifting in conjunction with [member time_pullout_ms]. Just pans sound to the left channel if [member time_pullout_ms] is 0.
var surround: float:
	get = get_surround, set = set_surround

## Widens sound stage through phase shifting in conjunction with [member surround]. Just delays the right channel if [member surround] is 0.
var time_pullout_ms: float:
	get = get_time_pullout, set = set_time_pullout




func get_pan_pullout() -> float:
	return pan_pullout

func set_pan_pullout(value: float) -> void:
	pan_pullout = value

func get_surround() -> float:
	return surround

func set_surround(value: float) -> void:
	surround = value

func get_time_pullout() -> float:
	return time_pullout_ms

func set_time_pullout(value: float) -> void:
	time_pullout_ms = value

