extends RefCounted
class_name AudioEffectInstance

## Manipulates the audio it receives for a given effect.
##
## An audio effect instance manipulates the audio it receives for a given effect. This instance is automatically created by an [AudioEffect] when it is added to a bus, and should usually not be created directly. If necessary, it can be fetched at run-time with [method AudioServer.get_bus_effect_instance].
##
## @tutorial(Audio buses): https://docs.godotengine.org/en/stable/tutorials/audio/audio_buses.html





## Called by the [AudioServer] to process this effect. When [method _process_silence] is not overridden or it returns [code]false[/code], this method is called only when the bus is active.
## [b]Note:[/b] It is not useful to override this method in GDScript or C#. Only GDExtension can take advantage of it.
func _process(src_buffer: const void*, dst_buffer: AudioFrame*, frame_count: int) -> void:
	pass;

## Override this method to customize the processing behavior of this effect instance.
## Should return [code]true[/code] to force the [AudioServer] to always call [method _process], even if the bus has been muted or cannot otherwise be heard.
func _process_silence() -> bool:
	pass;


