extends AudioEffect
class_name AudioEffectHardLimiter

## Adds a hard limiter audio effect to an Audio bus.
##
## A limiter is an effect designed to disallow sound from going over a given dB threshold. Hard limiters predict volume peaks, and will smoothly apply gain reduction when a peak crosses the ceiling threshold to prevent clipping and distortion. It preserves the waveform and prevents it from crossing the ceiling threshold. Adding one in the Master bus is recommended as a safety measure to prevent sudden volume peaks from occurring, and to prevent distortion caused by clipping.
##
## @tutorial(Audio buses): https://docs.godotengine.org/en/stable/tutorials/audio/audio_buses.html



## The waveform's maximum allowed value, in decibels. This value can range from [code]-24.0[/code] to [code]0.0[/code].
## The default value of [code]-0.3[/code] prevents potential inter-sample peaks (ISP) from crossing over 0 dB, which can cause slight distortion on some older hardware.
var ceiling_db: float:
	get = get_ceiling_db, set = set_ceiling_db

## Gain to apply before limiting, in decibels.
var pre_gain_db: float:
	get = get_pre_gain_db, set = set_pre_gain_db

## Time it takes in seconds for the gain reduction to fully release.
var release: float:
	get = get_release, set = set_release




func get_ceiling_db() -> float:
	return ceiling_db

func set_ceiling_db(value: float) -> void:
	ceiling_db = value

func get_pre_gain_db() -> float:
	return pre_gain_db

func set_pre_gain_db(value: float) -> void:
	pre_gain_db = value

func get_release() -> float:
	return release

func set_release(value: float) -> void:
	release = value

