extends Object
class_name XRVRS

## Helper class for XR interfaces that generates VRS images.
##
## This class is used by various XR interfaces to generate VRS textures that can be used to speed up rendering.



## The minimum radius around the focal point where full quality is guaranteed if VRS is used as a percentage of screen size.
var vrs_min_radius: float:
	get = get_vrs_min_radius, set = set_vrs_min_radius

## The strength used to calculate the VRS density map. The greater this value, the more noticeable VRS is.
var vrs_strength: float:
	get = get_vrs_strength, set = set_vrs_strength



## Generates the VRS texture based on a render [param target_size] adjusted by our VRS tile size. For each eyes focal point passed in [param eye_foci] a layer is created. Focal point should be in NDC.
## The result will be cached, requesting a VRS texture with unchanged parameters and settings will return the cached RID.
func make_vrs_texture(target_size: Vector2, eye_foci: PackedVector2Array) -> RID:
	pass;


func get_vrs_min_radius() -> float:
	return vrs_min_radius

func set_vrs_min_radius(value: float) -> void:
	vrs_min_radius = value

func get_vrs_strength() -> float:
	return vrs_strength

func set_vrs_strength(value: float) -> void:
	vrs_strength = value

