extends XRPositionalTracker
class_name XRBodyTracker

## A tracked body in XR.
##
## A body tracking system will create an instance of this object and add it to the [XRServer]. This tracking system will then obtain skeleton data, convert it to the Godot Humanoid skeleton and store this data on the [XRBodyTracker] object.
## Use [XRBodyModifier3D] to animate a body mesh using body tracking data.
##
## @tutorial(XR documentation index): https://docs.godotengine.org/en/stable/tutorials/xr/index.html


## Upper body tracking supported.
## Lower body tracking supported.
## Hand tracking supported.
## Root joint.
## Hips joint.
## Spine joint.
## Chest joint.
## Upper chest joint.
## Neck joint.
## Head joint.
## Head tip joint.
## Left shoulder joint.
## Left upper arm joint.
## Left lower arm joint.
## Right shoulder joint.
## Right upper arm joint.
## Right lower arm joint.
## Left upper leg joint.
## Left lower leg joint.
## Left foot joint.
## Left toes joint.
## Right upper leg joint.
## Right lower leg joint.
## Right foot joint.
## Right toes joint.
## Left hand joint.
## Left palm joint.
## Left wrist joint.
## Left thumb metacarpal joint.
## Left thumb phalanx proximal joint.
## Left thumb phalanx distal joint.
## Left thumb tip joint.
## Left index finger metacarpal joint.
## Left index finger phalanx proximal joint.
## Left index finger phalanx intermediate joint.
## Left index finger phalanx distal joint.
## Left index finger tip joint.
## Left middle finger metacarpal joint.
## Left middle finger phalanx proximal joint.
## Left middle finger phalanx intermediate joint.
## Left middle finger phalanx distal joint.
## Left middle finger tip joint.
## Left ring finger metacarpal joint.
## Left ring finger phalanx proximal joint.
## Left ring finger phalanx intermediate joint.
## Left ring finger phalanx distal joint.
## Left ring finger tip joint.
## Left pinky finger metacarpal joint.
## Left pinky finger phalanx proximal joint.
## Left pinky finger phalanx intermediate joint.
## Left pinky finger phalanx distal joint.
## Left pinky finger tip joint.
## Right hand joint.
## Right palm joint.
## Right wrist joint.
## Right thumb metacarpal joint.
## Right thumb phalanx proximal joint.
## Right thumb phalanx distal joint.
## Right thumb tip joint.
## Right index finger metacarpal joint.
## Right index finger phalanx proximal joint.
## Right index finger phalanx intermediate joint.
## Right index finger phalanx distal joint.
## Right index finger tip joint.
## Right middle finger metacarpal joint.
## Right middle finger phalanx proximal joint.
## Right middle finger phalanx intermediate joint.
## Right middle finger phalanx distal joint.
## Right middle finger tip joint.
## Right ring finger metacarpal joint.
## Right ring finger phalanx proximal joint.
## Right ring finger phalanx intermediate joint.
## Right ring finger phalanx distal joint.
## Right ring finger tip joint.
## Right pinky finger metacarpal joint.
## Right pinky finger phalanx proximal joint.
## Right pinky finger phalanx intermediate joint.
## Right pinky finger phalanx distal joint.
## Right pinky finger tip joint.
## Represents the size of the [enum Joint] enum.
## The joint's orientation data is valid.
## The joint's orientation is actively tracked. May not be set if tracking has been temporarily lost.
## The joint's position data is valid.
## The joint's position is actively tracked. May not be set if tracking has been temporarily lost.

#enum BodyFlags
enum {
    BODY_FLAG_UPPER_BODY_SUPPORTED = 1,
    BODY_FLAG_LOWER_BODY_SUPPORTED = 2,
    BODY_FLAG_HANDS_SUPPORTED = 4,
}
#enum Joint
enum {
    JOINT_ROOT = 0,
    JOINT_HIPS = 1,
    JOINT_SPINE = 2,
    JOINT_CHEST = 3,
    JOINT_UPPER_CHEST = 4,
    JOINT_NECK = 5,
    JOINT_HEAD = 6,
    JOINT_HEAD_TIP = 7,
    JOINT_LEFT_SHOULDER = 8,
    JOINT_LEFT_UPPER_ARM = 9,
    JOINT_LEFT_LOWER_ARM = 10,
    JOINT_RIGHT_SHOULDER = 11,
    JOINT_RIGHT_UPPER_ARM = 12,
    JOINT_RIGHT_LOWER_ARM = 13,
    JOINT_LEFT_UPPER_LEG = 14,
    JOINT_LEFT_LOWER_LEG = 15,
    JOINT_LEFT_FOOT = 16,
    JOINT_LEFT_TOES = 17,
    JOINT_RIGHT_UPPER_LEG = 18,
    JOINT_RIGHT_LOWER_LEG = 19,
    JOINT_RIGHT_FOOT = 20,
    JOINT_RIGHT_TOES = 21,
    JOINT_LEFT_HAND = 22,
    JOINT_LEFT_PALM = 23,
    JOINT_LEFT_WRIST = 24,
    JOINT_LEFT_THUMB_METACARPAL = 25,
    JOINT_LEFT_THUMB_PHALANX_PROXIMAL = 26,
    JOINT_LEFT_THUMB_PHALANX_DISTAL = 27,
    JOINT_LEFT_THUMB_TIP = 28,
    JOINT_LEFT_INDEX_FINGER_METACARPAL = 29,
    JOINT_LEFT_INDEX_FINGER_PHALANX_PROXIMAL = 30,
    JOINT_LEFT_INDEX_FINGER_PHALANX_INTERMEDIATE = 31,
    JOINT_LEFT_INDEX_FINGER_PHALANX_DISTAL = 32,
    JOINT_LEFT_INDEX_FINGER_TIP = 33,
    JOINT_LEFT_MIDDLE_FINGER_METACARPAL = 34,
    JOINT_LEFT_MIDDLE_FINGER_PHALANX_PROXIMAL = 35,
    JOINT_LEFT_MIDDLE_FINGER_PHALANX_INTERMEDIATE = 36,
    JOINT_LEFT_MIDDLE_FINGER_PHALANX_DISTAL = 37,
    JOINT_LEFT_MIDDLE_FINGER_TIP = 38,
    JOINT_LEFT_RING_FINGER_METACARPAL = 39,
    JOINT_LEFT_RING_FINGER_PHALANX_PROXIMAL = 40,
    JOINT_LEFT_RING_FINGER_PHALANX_INTERMEDIATE = 41,
    JOINT_LEFT_RING_FINGER_PHALANX_DISTAL = 42,
    JOINT_LEFT_RING_FINGER_TIP = 43,
    JOINT_LEFT_PINKY_FINGER_METACARPAL = 44,
    JOINT_LEFT_PINKY_FINGER_PHALANX_PROXIMAL = 45,
    JOINT_LEFT_PINKY_FINGER_PHALANX_INTERMEDIATE = 46,
    JOINT_LEFT_PINKY_FINGER_PHALANX_DISTAL = 47,
    JOINT_LEFT_PINKY_FINGER_TIP = 48,
    JOINT_RIGHT_HAND = 49,
    JOINT_RIGHT_PALM = 50,
    JOINT_RIGHT_WRIST = 51,
    JOINT_RIGHT_THUMB_METACARPAL = 52,
    JOINT_RIGHT_THUMB_PHALANX_PROXIMAL = 53,
    JOINT_RIGHT_THUMB_PHALANX_DISTAL = 54,
    JOINT_RIGHT_THUMB_TIP = 55,
    JOINT_RIGHT_INDEX_FINGER_METACARPAL = 56,
    JOINT_RIGHT_INDEX_FINGER_PHALANX_PROXIMAL = 57,
    JOINT_RIGHT_INDEX_FINGER_PHALANX_INTERMEDIATE = 58,
    JOINT_RIGHT_INDEX_FINGER_PHALANX_DISTAL = 59,
    JOINT_RIGHT_INDEX_FINGER_TIP = 60,
    JOINT_RIGHT_MIDDLE_FINGER_METACARPAL = 61,
    JOINT_RIGHT_MIDDLE_FINGER_PHALANX_PROXIMAL = 62,
    JOINT_RIGHT_MIDDLE_FINGER_PHALANX_INTERMEDIATE = 63,
    JOINT_RIGHT_MIDDLE_FINGER_PHALANX_DISTAL = 64,
    JOINT_RIGHT_MIDDLE_FINGER_TIP = 65,
    JOINT_RIGHT_RING_FINGER_METACARPAL = 66,
    JOINT_RIGHT_RING_FINGER_PHALANX_PROXIMAL = 67,
    JOINT_RIGHT_RING_FINGER_PHALANX_INTERMEDIATE = 68,
    JOINT_RIGHT_RING_FINGER_PHALANX_DISTAL = 69,
    JOINT_RIGHT_RING_FINGER_TIP = 70,
    JOINT_RIGHT_PINKY_FINGER_METACARPAL = 71,
    JOINT_RIGHT_PINKY_FINGER_PHALANX_PROXIMAL = 72,
    JOINT_RIGHT_PINKY_FINGER_PHALANX_INTERMEDIATE = 73,
    JOINT_RIGHT_PINKY_FINGER_PHALANX_DISTAL = 74,
    JOINT_RIGHT_PINKY_FINGER_TIP = 75,
    JOINT_MAX = 76,
}
#enum JointFlags
enum {
    JOINT_FLAG_ORIENTATION_VALID = 1,
    JOINT_FLAG_ORIENTATION_TRACKED = 2,
    JOINT_FLAG_POSITION_VALID = 4,
    JOINT_FLAG_POSITION_TRACKED = 8,
}
## The type of body tracking data captured.
var body_flags: int:
	get = get_body_flags, set = set_body_flags

## If [code]true[/code], the body tracking data is valid.
var has_tracking_data: bool:
	get = get_has_tracking_data, set = set_has_tracking_data

var type: int:
	get = get_tracker_type, set = set_tracker_type



## Returns flags about the validity of the tracking data for the given body joint (see [enum XRBodyTracker.JointFlags]).
func get_joint_flags(joint: int) -> int:
	pass;

## Returns the transform for the given body joint.
func get_joint_transform(joint: int) -> Transform3D:
	pass;

## Sets flags about the validity of the tracking data for the given body joint.
func set_joint_flags(joint: int, flags: int) -> void:
	pass;

## Sets the transform for the given body joint.
func set_joint_transform(joint: int, transform: Transform3D) -> void:
	pass;


func get_body_flags() -> int:
	return body_flags

func set_body_flags(value: int) -> void:
	body_flags = value

func get_has_tracking_data() -> bool:
	return has_tracking_data

func set_has_tracking_data(value: bool) -> void:
	has_tracking_data = value

func get_tracker_type() -> int:
	return type

func set_tracker_type(value: int) -> void:
	type = value

