extends Texture2D
class_name ViewportTexture

## Provides the content of a [Viewport] as a dynamic texture.
##
## A [ViewportTexture] provides the content of a [Viewport] as a dynamic [Texture2D]. This can be used to combine the rendering of [Control], [Node2D] and [Node3D] nodes. For example, you can use this texture to display a 3D scene inside a [TextureRect], or a 2D overlay in a [Sprite3D].
## To get a [ViewportTexture] in code, use the [method Viewport.get_texture] method on the target viewport.
## [b]Note:[/b] A [ViewportTexture] is always local to its scene (see [member Resource.resource_local_to_scene]). If the scene root is not ready, it may return incorrect data (see [signal Node.ready]).
## [b]Note:[/b] Instantiating scenes containing a high-resolution [ViewportTexture] may cause noticeable stutter.
##
## @tutorial(GUI in 3D Viewport Demo): https://godotengine.org/asset-library/asset/2807
## @tutorial(3D in 2D Viewport Demo): https://godotengine.org/asset-library/asset/2804
## @tutorial(2D in 3D Viewport Demo): https://godotengine.org/asset-library/asset/2803
## @tutorial(3D Resolution Scaling Demo): https://godotengine.org/asset-library/asset/2805



## The path to the [Viewport] node to display. This is relative to the local scene root (see [method Resource.get_local_scene]), [b]not[/b] to the nodes that use this texture.
## [b]Note:[/b] In the editor, this path is automatically updated when the target viewport or one of its ancestors is renamed or moved. At runtime, this path may not automatically update if the scene root cannot be found.
var viewport_path: NodePath:
	get = get_viewport_path_in_scene, set = set_viewport_path_in_scene




func get_viewport_path_in_scene() -> NodePath:
	return viewport_path

func set_viewport_path_in_scene(value: NodePath) -> void:
	viewport_path = value

