extends TextureLayered
class_name TextureLayeredRD

## Abstract base class for layered texture RD types.
##
## Base class for [Texture2DArrayRD], [TextureCubemapRD] and [TextureCubemapArrayRD]. Cannot be used directly, but contains all the functions necessary for accessing the derived resource types.



## The RID of the texture object created on the [RenderingDevice].
var texture_rd_rid: RID:
	get = get_texture_rd_rid, set = set_texture_rd_rid




func get_texture_rd_rid() -> RID:
	return texture_rd_rid

func set_texture_rd_rid(value: RID) -> void:
	texture_rd_rid = value

