extends Texture
class_name Texture3D

## Base class for 3-dimensional textures.
##
## Base class for [ImageTexture3D] and [CompressedTexture3D]. Cannot be used directly, but contains all the functions necessary for accessing the derived resource types. [Texture3D] is the base class for all 3-dimensional texture types. See also [TextureLayered].
## All images need to have the same width, height and number of mipmap levels.
## To create such a texture file yourself, reimport your image files using the Godot Editor import presets.





## Called when the [Texture3D]'s data is queried.
func _get_data() -> Array[Image]:
	pass;

## Called when the [Texture3D]'s depth is queried.
func _get_depth() -> int:
	pass;

## Called when the [Texture3D]'s format is queried.
func _get_format() -> int:
	pass;

## Called when the [Texture3D]'s height is queried.
func _get_height() -> int:
	pass;

## Called when the [Texture3D]'s width is queried.
func _get_width() -> int:
	pass;

## Called when the presence of mipmaps in the [Texture3D] is queried.
func _has_mipmaps() -> bool:
	pass;

## Creates a placeholder version of this resource ([PlaceholderTexture3D]).
func create_placeholder() -> Resource:
	pass;

## Returns the [Texture3D]'s data as an array of [Image]s. Each [Image] represents a [i]slice[/i] of the [Texture3D], with different slices mapping to different depth (Z axis) levels.
func get_data() -> Array[Image]:
	pass;

## Returns the [Texture3D]'s depth in pixels. Depth is typically represented by the Z axis (a dimension not present in [Texture2D]).
func get_depth() -> int:
	pass;

## Returns the current format being used by this texture. See [enum Image.Format] for details.
func get_format() -> int:
	pass;

## Returns the [Texture3D]'s height in pixels. Width is typically represented by the Y axis.
func get_height() -> int:
	pass;

## Returns the [Texture3D]'s width in pixels. Width is typically represented by the X axis.
func get_width() -> int:
	pass;

## Returns [code]true[/code] if the [Texture3D] has generated mipmaps.
func has_mipmaps() -> bool:
	pass;


