extends Light3D
class_name SpotLight3D

## A spotlight, such as a reflector spotlight or a lantern.
##
## A Spotlight is a type of [Light3D] node that emits lights in a specific direction, in the shape of a cone. The light is attenuated through the distance. This attenuation can be configured by changing the energy, radius and attenuation parameters of [Light3D].
## [b]Note:[/b] When using the Mobile rendering method, only 8 spot lights can be displayed on each mesh resource. Attempting to display more than 8 spot lights on a single mesh resource will result in spot lights flickering in and out as the camera moves. When using the Compatibility rendering method, only 8 spot lights can be displayed on each mesh resource by default, but this can be increased by adjusting [member ProjectSettings.rendering/limits/opengl/max_lights_per_object].
## [b]Note:[/b] When using the Mobile or Compatibility rendering methods, spot lights will only correctly affect meshes whose visibility AABB intersects with the light's AABB. If using a shader to deform the mesh in a way that makes it go outside its AABB, [member GeometryInstance3D.extra_cull_margin] must be increased on the mesh. Otherwise, the light may not be visible on the mesh.
##
## @tutorial(3D lights and shadows): https://docs.godotengine.org/en/stable/tutorials/3d/lights_and_shadows.html
## @tutorial(Faking global illumination): https://docs.godotengine.org/en/stable/tutorials/3d/global_illumination/faking_global_illumination.html
## @tutorial(Third Person Shooter (TPS) Demo): https://godotengine.org/asset-library/asset/2710



var shadow_bias: float:
	get = get_param, set = set_param

var shadow_normal_bias: float:
	get = get_param, set = set_param

## The spotlight's angle in degrees.
## [b]Note:[/b] [member spot_angle] is not affected by [member Node3D.scale] (the light's scale or its parent's scale).
var spot_angle: float:
	get = get_param, set = set_param

## The spotlight's [i]angular[/i] attenuation curve. See also [member spot_attenuation].
var spot_angle_attenuation: float:
	get = get_param, set = set_param

## Controls the distance attenuation function for spotlights.
## A value of [code]0.0[/code] will maintain a constant brightness through most of the range, but smoothly attenuate the light at the edge of the range. Use a value of [code]2.0[/code] for physically accurate lights as it results in the proper inverse square attenutation.
## [b]Note:[/b] Setting attenuation to [code]2.0[/code] or higher may result in distant objects receiving minimal light, even within range. For example, with a range of [code]4096[/code], an object at [code]100[/code] units is attenuated by a factor of [code]0.0001[/code]. With a default brightness of [code]1[/code], the light would not be visible at that distance.
## [b]Note:[/b] Using negative or values higher than [code]10.0[/code] may lead to unexpected results.
var spot_attenuation: float:
	get = get_param, set = set_param

## The maximal range that can be reached by the spotlight. Note that the effectively lit area may appear to be smaller depending on the [member spot_attenuation] in use. No matter the [member spot_attenuation] in use, the light will never reach anything outside this range.
## [b]Note:[/b] [member spot_range] is not affected by [member Node3D.scale] (the light's scale or its parent's scale).
var spot_range: float:
	get = get_param, set = set_param




func get_param() -> float:
	return shadow_bias

func set_param(value: float) -> void:
	shadow_bias = value

func get_param() -> float:
	return shadow_normal_bias

func set_param(value: float) -> void:
	shadow_normal_bias = value

func get_param() -> float:
	return spot_angle

func set_param(value: float) -> void:
	spot_angle = value

func get_param() -> float:
	return spot_angle_attenuation

func set_param(value: float) -> void:
	spot_angle_attenuation = value

func get_param() -> float:
	return spot_attenuation

func set_param(value: float) -> void:
	spot_attenuation = value

func get_param() -> float:
	return spot_range

func set_param(value: float) -> void:
	spot_range = value

