extends SkeletonProfile
class_name SkeletonProfileHumanoid

## A humanoid [SkeletonProfile] preset.
##
## A [SkeletonProfile] as a preset that is optimized for the human form. This exists for standardization, so all parameters are read-only.
## A humanoid skeleton profile contains 54 bones divided in 4 groups: [code]"Body"[/code], [code]"Face"[/code], [code]"LeftHand"[/code], and [code]"RightHand"[/code]. It is structured as follows:
## [codeblock lang=text]
## Root
## └─ Hips
## ├─ LeftUpperLeg
## │  └─ LeftLowerLeg
## │     └─ LeftFoot
## │        └─ LeftToes
## ├─ RightUpperLeg
## │  └─ RightLowerLeg
## │     └─ RightFoot
## │        └─ RightToes
## └─ Spine
## └─ Chest
## └─ UpperChest
## ├─ Neck
## │   └─ Head
## │       ├─ Jaw
## │       ├─ LeftEye
## │       └─ RightEye
## ├─ LeftShoulder
## │  └─ LeftUpperArm
## │     └─ LeftLowerArm
## │        └─ LeftHand
## │           ├─ LeftThumbMetacarpal
## │           │  └─ LeftThumbProximal
## │           ├─ LeftIndexProximal
## │           │  └─ LeftIndexIntermediate
## │           │    └─ LeftIndexDistal
## │           ├─ LeftMiddleProximal
## │           │  └─ LeftMiddleIntermediate
## │           │    └─ LeftMiddleDistal
## │           ├─ LeftRingProximal
## │           │  └─ LeftRingIntermediate
## │           │    └─ LeftRingDistal
## │           └─ LeftLittleProximal
## │              └─ LeftLittleIntermediate
## │                └─ LeftLittleDistal
## └─ RightShoulder
## └─ RightUpperArm
## └─ RightLowerArm
## └─ RightHand
## ├─ RightThumbMetacarpal
## │  └─ RightThumbProximal
## ├─ RightIndexProximal
## │  └─ RightIndexIntermediate
## │     └─ RightIndexDistal
## ├─ RightMiddleProximal
## │  └─ RightMiddleIntermediate
## │     └─ RightMiddleDistal
## ├─ RightRingProximal
## │  └─ RightRingIntermediate
## │     └─ RightRingDistal
## └─ RightLittleProximal
## └─ RightLittleIntermediate
## └─ RightLittleDistal
## [/codeblock]
##
## @tutorial(Retargeting 3D Skeletons): https://docs.godotengine.org/en/stable/tutorials/assets_pipeline/retargeting_3d_skeletons.html



var bone_size: int:
	get = get_bone_size, set = set_bone_size

var group_size: int:
	get = get_group_size, set = set_group_size

var root_bone: StringName:
	get = get_root_bone, set = set_root_bone

var scale_base_bone: StringName:
	get = get_scale_base_bone, set = set_scale_base_bone




func get_bone_size() -> int:
	return bone_size

func set_bone_size(value: int) -> void:
	bone_size = value

func get_group_size() -> int:
	return group_size

func set_group_size(value: int) -> void:
	group_size = value

func get_root_bone() -> StringName:
	return root_bone

func set_root_bone(value: StringName) -> void:
	root_bone = value

func get_scale_base_bone() -> StringName:
	return scale_base_bone

func set_scale_base_bone(value: StringName) -> void:
	scale_base_bone = value

