extends SkeletonModification2D
class_name SkeletonModification2DLookAt

## A modification that rotates a [Bone2D] node to look at a target.
##
## This [SkeletonModification2D] rotates a bone to look a target. This is extremely helpful for moving character's head to look at the player, rotating a turret to look at a target, or any other case where you want to make a bone rotate towards something quickly and easily.



## The [Bone2D] node that the modification will operate on.
var bone2d_node: NodePath:
	get = get_bone2d_node, set = set_bone2d_node

## The index of the [Bone2D] node that the modification will operate on.
var bone_index: int:
	get = get_bone_index, set = set_bone_index

## The NodePath to the node that is the target for the LookAt modification. This node is what the modification will rotate the [Bone2D] to.
var target_nodepath: NodePath:
	get = get_target_node, set = set_target_node



## Returns the amount of additional rotation that is applied after the LookAt modification executes.
func get_additional_rotation() -> float:
	pass;

## Returns whether the constraints to this modification are inverted or not.
func get_constraint_angle_invert() -> bool:
	pass;

## Returns the constraint's maximum allowed angle.
func get_constraint_angle_max() -> float:
	pass;

## Returns the constraint's minimum allowed angle.
func get_constraint_angle_min() -> float:
	pass;

## Returns [code]true[/code] if the LookAt modification is using constraints.
func get_enable_constraint() -> bool:
	pass;

## Sets the amount of additional rotation that is to be applied after executing the modification. This allows for offsetting the results by the inputted rotation amount.
func set_additional_rotation(rotation: float) -> void:
	pass;

## When [code]true[/code], the modification will use an inverted joint constraint.
## An inverted joint constraint only constraints the [Bone2D] to the angles [i]outside of[/i] the inputted minimum and maximum angles. For this reason, it is referred to as an inverted joint constraint, as it constraints the joint to the outside of the inputted values.
func set_constraint_angle_invert(invert: bool) -> void:
	pass;

## Sets the constraint's maximum allowed angle.
func set_constraint_angle_max(angle_max: float) -> void:
	pass;

## Sets the constraint's minimum allowed angle.
func set_constraint_angle_min(angle_min: float) -> void:
	pass;

## Sets whether this modification will use constraints or not. When [code]true[/code], constraints will be applied when solving the LookAt modification.
func set_enable_constraint(enable_constraint: bool) -> void:
	pass;


func get_bone2d_node() -> NodePath:
	return bone2d_node

func set_bone2d_node(value: NodePath) -> void:
	bone2d_node = value

func get_bone_index() -> int:
	return bone_index

func set_bone_index(value: int) -> void:
	bone_index = value

func get_target_node() -> NodePath:
	return target_nodepath

func set_target_node(value: NodePath) -> void:
	target_nodepath = value

