extends Material
class_name ShaderMaterial

## A material defined by a custom [Shader] program and the values of its shader parameters.
##
## A material that uses a custom [Shader] program to render visual items (canvas items, meshes, skies, fog), or to process particles. Compared to other materials, [ShaderMaterial] gives deeper control over the generated shader code. For more information, see the shaders documentation index below.
## Multiple [ShaderMaterial]s can use the same shader and configure different values for the shader uniforms.
## [b]Note:[/b] For performance reasons, the [signal Resource.changed] signal is only emitted when the [member Resource.resource_name] changes. Only in editor, it is also emitted for [member shader] changes.
##
## @tutorial(Shaders documentation index): https://docs.godotengine.org/en/stable/tutorials/shaders/index.html



## The [Shader] program used to render this material.
var shader: Shader:
	get = get_shader, set = set_shader



## Returns the current value set for this material of a uniform in the shader.
func get_shader_parameter(param: StringName) -> Variant:
	pass;

## Changes the value set for this material of a uniform in the shader.
## [b]Note:[/b] [param param] is case-sensitive and must match the name of the uniform in the code exactly (not the capitalized name in the inspector).
## [b]Note:[/b] Changes to the shader uniform will be effective on all instances using this [ShaderMaterial]. To prevent this, use per-instance uniforms with [method GeometryInstance3D.set_instance_shader_parameter] or duplicate the [ShaderMaterial] resource using [method Resource.duplicate]. Per-instance uniforms allow for better shader reuse and are therefore faster, so they should be preferred over duplicating the [ShaderMaterial] when possible.
func set_shader_parameter(param: StringName, value: Variant) -> void:
	pass;


func get_shader() -> Shader:
	return shader

func set_shader(value: Shader) -> void:
	shader = value

