extends PanelContainer
class_name ScriptEditor

## Godot editor's script editor.
##
## Godot editor's script editor.
## [b]Note:[/b] This class shouldn't be instantiated directly. Instead, access the singleton using [method EditorInterface.get_script_editor].


## Emitted when user changed active script. Argument is a freshly activated [Script].
signal editor_script_changed(script: Script)
## Emitted when editor is about to close the active script. Argument is a [Script] that is going to be closed.
signal script_close(script: Script)



## Returns the [ScriptEditorBase] object that the user is currently editing.
func get_current_editor() -> ScriptEditorBase:
	pass;

## Returns a [Script] that is currently active in editor.
func get_current_script() -> Script:
	pass;

## Returns an array with all [ScriptEditorBase] objects which are currently open in editor.
func get_open_script_editors() -> Array[ScriptEditorBase]:
	pass;

## Returns an array with all [Script] objects which are currently open in editor.
func get_open_scripts() -> Array[Script]:
	pass;

## Opens help for the given topic. The [param topic] is an encoded string that controls which class, method, constant, signal, annotation, property, or theme item should be focused.
## The supported [param topic] formats include [code]class_name:class[/code], [code]class_method:class:method[/code], [code]class_constant:class:constant[/code], [code]class_signal:class:signal[/code], [code]class_annotation:class:@annotation[/code], [code]class_property:class:property[/code], and [code]class_theme_item:class:item[/code], where [code]class[/code] is the class name, [code]method[/code] is the method name, [code]constant[/code] is the constant name, [code]signal[/code] is the signal name, [code]annotation[/code] is the annotation name, [code]property[/code] is the property name, and [code]item[/code] is the theme item.
## [b]Examples:[/b]
## [codeblock]
## # Shows help for the Node class.
## class_name:Node
## # Shows help for the global min function.
## # Global objects are accessible in the `@GlobalScope` namespace, shown here.
## class_method:@GlobalScope:min
## # Shows help for get_viewport in the Node class.
## class_method:Node:get_viewport
## # Shows help for the Input constant MOUSE_BUTTON_MIDDLE.
## class_constant:Input:MOUSE_BUTTON_MIDDLE
## # Shows help for the BaseButton signal pressed.
## class_signal:BaseButton:pressed
## # Shows help for the CanvasItem property visible.
## class_property:CanvasItem:visible
## # Shows help for the GDScript annotation export.
## # Annotations should be prefixed with the `@` symbol in the descriptor, as shown here.
## class_annotation:@GDScript:@export
## # Shows help for the GraphNode theme item named panel_selected.
## class_theme_item:GraphNode:panel_selected
## [/codeblock]
func goto_help(topic: String) -> void:
	pass;

## Goes to the specified line in the current script.
func goto_line(line_number: int) -> void:
	pass;

## Opens the script create dialog. The script will extend [param base_name]. The file extension can be omitted from [param base_path]. It will be added based on the selected scripting language.
func open_script_create_dialog(base_name: String, base_path: String) -> void:
	pass;

## Registers the [EditorSyntaxHighlighter] to the editor, the [EditorSyntaxHighlighter] will be available on all open scripts.
## [b]Note:[/b] Does not apply to scripts that are already opened.
func register_syntax_highlighter(syntax_highlighter: EditorSyntaxHighlighter) -> void:
	pass;

## Unregisters the [EditorSyntaxHighlighter] from the editor.
## [b]Note:[/b] The [EditorSyntaxHighlighter] will still be applied to scripts that are already opened.
func unregister_syntax_highlighter(syntax_highlighter: EditorSyntaxHighlighter) -> void:
	pass;


