extends Object
class_name RenderSceneData

## Abstract render data object, holds scene data related to rendering a single frame of a viewport.
##
## Abstract scene data object, exists for the duration of rendering a single viewport.
## [b]Note:[/b] This is an internal rendering server object, do not instantiate this from script.





## Returns the camera projection used to render this frame.
## [b]Note:[/b] If more than one view is rendered, this will return a combined projection.
func get_cam_projection() -> Projection:
	pass;

## Returns the camera transform used to render this frame.
## [b]Note:[/b] If more than one view is rendered, this will return a centered transform.
func get_cam_transform() -> Transform3D:
	pass;

## Return the [RID] of the uniform buffer containing the scene data as a UBO.
func get_uniform_buffer() -> RID:
	pass;

## Returns the number of views being rendered.
func get_view_count() -> int:
	pass;

## Returns the eye offset per view used to render this frame. This is the offset between our camera transform and the eye transform.
func get_view_eye_offset(view: int) -> Vector3:
	pass;

## Returns the view projection per view used to render this frame.
## [b]Note:[/b] If a single view is rendered, this returns the camera projection. If more than one view is rendered, this will return a projection for the given view including the eye offset.
func get_view_projection(view: int) -> Projection:
	pass;


