class_name Rect2

## A 2D axis-aligned bounding box using floating-point coordinates.
##
## The [Rect2] built-in [Variant] type represents an axis-aligned rectangle in a 2D space. It is defined by its [member position] and [member size], which are [Vector2]. It is frequently used for fast overlap tests (see [method intersects]). Although [Rect2] itself is axis-aligned, it can be combined with [Transform2D] to represent a rotated or skewed rectangle.
## For integer coordinates, use [Rect2i]. The 3D equivalent to [Rect2] is [AABB].
## [b]Note:[/b] Negative values for [member size] are not supported. With negative size, most [Rect2] methods do not work correctly. Use [method abs] to get an equivalent [Rect2] with a non-negative size.
## [b]Note:[/b] In a boolean context, a [Rect2] evaluates to [code]false[/code] if both [member position] and [member size] are zero (equal to [constant Vector2.ZERO]). Otherwise, it always evaluates to [code]true[/code].
##
## @tutorial(Math documentation index): https://docs.godotengine.org/en/stable/tutorials/math/index.html
## @tutorial(Vector math): https://docs.godotengine.org/en/stable/tutorials/math/vector_math.html
## @tutorial(Advanced vector math): https://docs.godotengine.org/en/stable/tutorials/math/vectors_advanced.html



## The ending point. This is usually the bottom-right corner of the rectangle, and is equivalent to [code]position + size[/code]. Setting this point affects the [member size].
var end: Vector2

## The origin point. This is usually the top-left corner of the rectangle.
var position: Vector2

## The rectangle's width and height, starting from [member position]. Setting this value also affects the [member end] point.
## [b]Note:[/b] It's recommended setting the width and height to non-negative values, as most methods in Godot assume that the [member position] is the top-left corner, and the [member end] is the bottom-right corner. To get an equivalent rectangle with non-negative size, use [method abs].
var size: Vector2


## Constructs a [Rect2] with its [member position] and [member size] set to [constant Vector2.ZERO].
func Rect2() -> Rect2:
	pass;

## Constructs a [Rect2] as a copy of the given [Rect2].
func Rect2(from: Rect2) -> Rect2:
	pass;

## Constructs a [Rect2] from a [Rect2i].
func Rect2(from: Rect2i) -> Rect2:
	pass;

## Constructs a [Rect2] by [param position] and [param size].
func Rect2(position: Vector2, size: Vector2) -> Rect2:
	pass;

## Constructs a [Rect2] by setting its [member position] to ([param x], [param y]), and its [member size] to ([param width], [param height]).
func Rect2(x: float, y: float, width: float, height: float) -> Rect2:
	pass;


## Returns a [Rect2] equivalent to this rectangle, with its width and height modified to be non-negative values, and with its [member position] being the top-left corner of the rectangle.
## [codeblocks]
## [gdscript]
## var rect = Rect2(25, 25, -100, -50)
## var absolute = rect.abs() # absolute is Rect2(-75, -25, 100, 50)
## [/gdscript]
## [csharp]
## var rect = new Rect2(25, 25, -100, -50);
## var absolute = rect.Abs(); // absolute is Rect2(-75, -25, 100, 50)
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] It's recommended to use this method when [member size] is negative, as most other methods in Godot assume that the [member position] is the top-left corner, and the [member end] is the bottom-right corner.
func abs() -> Rect2:
	pass;

## Returns [code]true[/code] if this rectangle [i]completely[/i] encloses the [param b] rectangle.
func encloses(b: Rect2) -> bool:
	pass;

## Returns a copy of this rectangle expanded to align the edges with the given [param to] point, if necessary.
## [codeblocks]
## [gdscript]
## var rect = Rect2(0, 0, 5, 2)
## rect = rect.expand(Vector2(10, 0)) # rect is Rect2(0, 0, 10, 2)
## rect = rect.expand(Vector2(-5, 5)) # rect is Rect2(-5, 0, 15, 5)
## [/gdscript]
## [csharp]
## var rect = new Rect2(0, 0, 5, 2);
## rect = rect.Expand(new Vector2(10, 0)); // rect is Rect2(0, 0, 10, 2)
## rect = rect.Expand(new Vector2(-5, 5)); // rect is Rect2(-5, 0, 15, 5)
## [/csharp]
## [/codeblocks]
func expand(to: Vector2) -> Rect2:
	pass;

## Returns the rectangle's area. This is equivalent to [code]size.x * size.y[/code]. See also [method has_area].
func get_area() -> float:
	pass;

## Returns the center point of the rectangle. This is the same as [code]position + (size / 2.0)[/code].
func get_center() -> Vector2:
	pass;

## Returns a copy of this rectangle extended on all sides by the given [param amount]. A negative [param amount] shrinks the rectangle instead. See also [method grow_individual] and [method grow_side].
## [codeblocks]
## [gdscript]
## var a = Rect2(4, 4, 8, 8).grow(4) # a is Rect2(0, 0, 16, 16)
## var b = Rect2(0, 0, 8, 4).grow(2) # b is Rect2(-2, -2, 12, 8)
## [/gdscript]
## [csharp]
## var a = new Rect2(4, 4, 8, 8).Grow(4); // a is Rect2(0, 0, 16, 16)
## var b = new Rect2(0, 0, 8, 4).Grow(2); // b is Rect2(-2, -2, 12, 8)
## [/csharp]
## [/codeblocks]
func grow(amount: float) -> Rect2:
	pass;

## Returns a copy of this rectangle with its [param left], [param top], [param right], and [param bottom] sides extended by the given amounts. Negative values shrink the sides, instead. See also [method grow] and [method grow_side].
func grow_individual(left: float, top: float, right: float, bottom: float) -> Rect2:
	pass;

## Returns a copy of this rectangle with its [param side] extended by the given [param amount] (see [enum Side] constants). A negative [param amount] shrinks the rectangle, instead. See also [method grow] and [method grow_individual].
func grow_side(side: int, amount: float) -> Rect2:
	pass;

## Returns [code]true[/code] if this rectangle has positive width and height. See also [method get_area].
func has_area() -> bool:
	pass;

## Returns [code]true[/code] if the rectangle contains the given [param point]. By convention, points on the right and bottom edges are [b]not[/b] included.
## [b]Note:[/b] This method is not reliable for [Rect2] with a [i]negative[/i] [member size]. Use [method abs] first to get a valid rectangle.
func has_point(point: Vector2) -> bool:
	pass;

## Returns the intersection between this rectangle and [param b]. If the rectangles do not intersect, returns an empty [Rect2].
## [codeblocks]
## [gdscript]
## var rect1 = Rect2(0, 0, 5, 10)
## var rect2 = Rect2(2, 0, 8, 4)
## var a = rect1.intersection(rect2) # a is Rect2(2, 0, 3, 4)
## [/gdscript]
## [csharp]
## var rect1 = new Rect2(0, 0, 5, 10);
## var rect2 = new Rect2(2, 0, 8, 4);
## var a = rect1.Intersection(rect2); // a is Rect2(2, 0, 3, 4)
## [/csharp]
## [/codeblocks]
## [b]Note:[/b] If you only need to know whether two rectangles are overlapping, use [method intersects], instead.
func intersection(b: Rect2) -> Rect2:
	pass;

## Returns [code]true[/code] if this rectangle overlaps with the [param b] rectangle. The edges of both rectangles are excluded, unless [param include_borders] is [code]true[/code].
func intersects(b: Rect2, include_borders: bool = false) -> bool:
	pass;

## Returns [code]true[/code] if this rectangle and [param rect] are approximately equal, by calling [method Vector2.is_equal_approx] on the [member position] and the [member size].
func is_equal_approx(rect: Rect2) -> bool:
	pass;

## Returns [code]true[/code] if this rectangle's values are finite, by calling [method Vector2.is_finite] on the [member position] and the [member size].
func is_finite() -> bool:
	pass;

## Returns a [Rect2] that encloses both this rectangle and [param b] around the edges. See also [method encloses].
func merge(b: Rect2) -> Rect2:
	pass;


