class_name RID

## A handle for a [Resource]'s unique identifier.
##
## The RID [Variant] type is used to access a low-level resource by its unique ID. RIDs are opaque, which means they do not grant access to the resource by themselves. They are used by the low-level server classes, such as [DisplayServer], [RenderingServer], [TextServer], etc.
## A low-level resource may correspond to a high-level [Resource], such as [Texture] or [Mesh].
## [b]Note:[/b] RIDs are only useful during the current session. It won't correspond to a similar resource if sent over a network, or loaded from a file at a later time.




## Constructs an empty [RID] with the invalid ID [code]0[/code].
func RID() -> RID:
	pass;

## Constructs a [RID] as a copy of the given [RID].
func RID(from: RID) -> RID:
	pass;


## Returns the ID of the referenced low-level resource.
func get_id() -> int:
	pass;

## Returns [code]true[/code] if the [RID] is not [code]0[/code].
func is_valid() -> bool:
	pass;


