extends RefCounted
class_name RDUniform

## Shader uniform (used by [RenderingDevice]).
##
## This object is used by [RenderingDevice].



## The uniform's binding.
var binding: int:
	get = get_binding, set = set_binding

## The uniform's data type.
var uniform_type: int:
	get = get_uniform_type, set = set_uniform_type



## Binds the given id to the uniform. The data associated with the id is then used when the uniform is passed to a shader.
func add_id(id: RID) -> void:
	pass;

## Unbinds all ids currently bound to the uniform.
func clear_ids() -> void:
	pass;

## Returns an array of all ids currently bound to the uniform.
func get_ids() -> Array[RID]:
	pass;


func get_binding() -> int:
	return binding

func set_binding(value: int) -> void:
	binding = value

func get_uniform_type() -> int:
	return uniform_type

func set_uniform_type(value: int) -> void:
	uniform_type = value

